% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mregions2-package.R
\name{MRGID}
\alias{MRGID}
\title{Marine Regions Global Identifier or MRGID (Documentation)}
\value{
Returns a help page: \code{MRGID} is not a function but documentation.
}
\description{
Many functions of \link{mregions2} make use of the argument \code{mrgid} or return data with the numeric variable \code{MRGID}.

But what is this identifier?

This is an unique and persistent identifier of each entry in the Marine Regions Gazetteer. This identifier
consists in a URI containing a number, unique for each entry in the Marine Regions Gazetteer. The R package \link{mregions2}
uses this number in its functions, and it should be considered a synonym of the standard definition of MRGID.

See the section details for a more in depth definition of the \code{MRGID}
}
\details{
From \url{https://marineregions.org/mrgid.php} :
\subsection{Standards}{

Place names change over time, and the same names may be used for different locations. Available
gazetteers may find locations of some marine place names, but a truly global standard for marine
place names is lacking. Marine Regions tries to establish for the first time a standardized list
of georeferenced marine place names and marine areas. In order to preserve the identity of the marine
geographic objects from the database, and to name and locate the geographic resources on the web, we
promote the Marine Regions Geographic IDentifier, or the MRGID.
}

\subsection{MRGID}{

The Marine Regions Geographic IDentifier is:
\itemize{
\item \emph{unique} by using a URI (Uniform Resource Identifier), it's unique across the internet.

Syntax \verb{http://marineregions.org/mrgid/<number>}
\item \emph{persistent} we will never delete, nor change the concept behind an MRGID
\item \emph{resolvable} pointing your client to an MRGID will return
- the reply of the webservice call \code{getGazetteerRecordByMRGID}, when using content negotiation
(\code{text/turtle} or \code{application/ld+json})
- the webpage of the MRGID, when using a browser
}

For an identifier to be persistent, it requires the governing body to arrange for the identifier to
be available for the long term. Use of the MRGID, as URI and persistent identifier has the commitment
of the Flanders Marine Institute, issuing the identifier to maintain the http domain registration, and
a strategy for managing the domain and the web servers.
}
}
\examples{
\donttest{?MRGID}
}
