% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_mrp_view.R
\name{mrp_view}
\alias{mrp_view}
\alias{mrp_view_eez}
\alias{mrp_view_eez_boundaries}
\alias{mrp_view_eez_12nm}
\alias{mrp_view_eez_24nm}
\alias{mrp_view_eez_internal_waters}
\alias{mrp_view_eez_archipelagic_waters}
\alias{mrp_view_high_seas}
\alias{mrp_view_ecs}
\alias{mrp_view_ecs_boundaries}
\alias{mrp_view_iho}
\alias{mrp_view_goas}
\alias{mrp_view_eez_iho}
\alias{mrp_view_eez_land}
\alias{mrp_view_longhurst}
\alias{mrp_view_cds}
\alias{mrp_view_eca_reg13_nox}
\alias{mrp_view_eca_reg14_sox_pm}
\alias{mrp_view_worldheritagemarineprogramme}
\alias{mrp_view_lme}
\alias{mrp_view_ecoregions}
\alias{mrp_view_seavox_v18}
\title{Visualize a Marine Regions data product without downloading.}
\usage{
mrp_view(layer, cql_filter = NULL, filter = NULL)

mrp_view_eez(...)

mrp_view_eez_boundaries(...)

mrp_view_eez_12nm(...)

mrp_view_eez_24nm(...)

mrp_view_eez_internal_waters(...)

mrp_view_eez_archipelagic_waters(...)

mrp_view_high_seas(...)

mrp_view_ecs(...)

mrp_view_ecs_boundaries(...)

mrp_view_iho(...)

mrp_view_goas(...)

mrp_view_eez_iho(...)

mrp_view_eez_land(...)

mrp_view_longhurst(...)

mrp_view_cds(...)

mrp_view_eca_reg13_nox(...)

mrp_view_eca_reg14_sox_pm(...)

mrp_view_worldheritagemarineprogramme(...)

mrp_view_lme(...)

mrp_view_ecoregions(...)

mrp_view_seavox_v18(...)
}
\arguments{
\item{layer}{(character) Identifier of the data product. See \link{mrp_list}}

\item{cql_filter}{(character) Contextual Query Language (CQL) filter. See details.}

\item{filter}{(character) Standard OGC filter specification. See details.}

\item{...}{pass the \code{cql_filter} and \code{filter} parameters to \code{\link[=mrp_view]{mrp_view()}} when using one of the helpers}
}
\value{
A leaflet map with a data product visualized via WMS
}
\description{
Visualize a Marine Regions data product without downloading.

A series of helpers are available to ease the selection of the data products. Example: instead of running

\code{mrp_view("eez")}

You can use

\code{mrp_view_eez()}

Try \verb{mrp_view_*()}with the identifier of the data product (see \link{mrp_list})
}
\details{
This function uses \href{https://en.wikipedia.org/wiki/Web_Map_Service}{WMS services} to load quickly
a Leaflet viewer of a Marine Regions data product. It uses the \href{https://emodnet.ec.europa.eu/en}{EMODnet Bathymetry} Digital Terrain Model as background layer.
\subsection{Filters}{

Both the \href{https://portal.ogc.org/files/96288}{Contextual Query Language (CQL) filter} and the \href{https://www.ogc.org/standard/filter/}{standard OGC filter specification} allow to
query the server before performing a request. This will boost performance as you will only retrieve the area of your interest. It is possible to query on attributes, but also perform
geospatial queries. For instance, you can query a bounding box of interest.

CQL filters are possible only in geoserver. Marine Regions uses a geoserver instance to serve its data products.
A tutorial on CQL filters is available in the \href{https://docs.geoserver.org/stable/en/user/tutorials/cql/cql_tutorial.html}{geoserver web site}.
}
}
\examples{
\donttest{
# You can pass a product name from mrp_list
mrp_view('eez')

# Or use the helper
mrp_view_eez()

# Example: filter a the Ecoregions 'Azores Canaries Madeira' with mrgid 21885
# You can check the names of the columns beforehand with mrp_colnames('ecoregions')
mrp_view_ecoregions(filter = "
  <Filter>
    <PropertyIsEqualTo>
      <PropertyName>ecoregion</PropertyName>
      <Literal>Azores Canaries Madeira</Literal>
    </PropertyIsEqualTo>
  </Filter>
")

# OGC filter are very verbose... but luckily you can use a CQL filter instead
mrp_view_ecoregions(cql_filter = "ecoregion = 'Azores Canaries Madeira'")

# View all the Extended Continental Shelf (ECS) boundary lines published during the first
# decade of the 21st century
mrp_view_ecs_boundaries(
  cql_filter = "doc_date > '2000-01-01' AND doc_date < '2009-12-31'"
)

# Or as timestamp
mrp_view_eez_boundaries(
  cql_filter = "doc_date AFTER 2000-01-01T00:00:00Z AND doc_date BEFORE 2009-12-31T00:00:00Z"
)
}
}
\seealso{
\link{mrp_list} to describe the list of products, \code{\link[=mrp_colnames]{mrp_colnames()}} and \code{\link[=mrp_col_unique]{mrp_col_unique()}} to get the name, data type and unique values of a the columns of a data product, useful to query
with the arguments \code{cql_filter} or \code{filter}, \code{\link[=mrp_get]{mrp_get()}} to get the data products as a \href{https://r-spatial.github.io/sf/}{simple feature} object.
}
