% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relsurv.msboot.relsurv.boot.R
\name{msboot.relsurv.boot}
\alias{msboot.relsurv.boot}
\title{Default theta function used for msboot.relsurv}
\usage{
msboot.relsurv.boot(
  data,
  transmat,
  all_times,
  split.transitions,
  rmap,
  time.format,
  boot_orig_msfit = FALSE,
  ratetable = relsurv::slopop,
  add.times
)
}
\arguments{
\item{data}{An object of class 'msdata' containing a bootstrapped sample}

\item{transmat}{The transition matrix of class transMat}

\item{all_times}{All times at which the hazards have to be evaluated}

\item{split.transitions}{An integer vector containing the numbered transitions that should be split. Use same numbering as in the given transition matrix}

\item{rmap}{An optional list to be used if the variables in the dataset are not organized (and named) in the same way as in the ratetable object}

\item{time.format}{Define the time format which is used in the dataset Possible options: c('days', 'years', 'months'). Default is 'days'}

\item{boot_orig_msfit}{Logical, if true, do the bootstrap for the basic msfit model}

\item{ratetable}{The population mortality table. A table of event rates, organized as a ratetable object, see for example relsurv::slopop. Default is slopop}

\item{add.times}{Additional times at which hazards should be evaluated}
}
\value{
A list of calculated values for the given bootstrap sample.
}
\description{
Helper function used for calling inside msboot.relsurv
(used for every bootstrap dataset).
This function is used for calculating split hazards
and evaluating them at all needed times.
}
\seealso{
\code{\link{msboot.relsurv}}
}
\author{
Damjan Manevski \email{damjan.manevski@mf.uni-lj.si}
}
