% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cell_id.R
\name{get_cell_id}
\alias{get_cell_id}
\title{Function to generate cell ID based on 1D sammons projection}
\usage{
get_cell_id(hvt.results)
}
\arguments{
\item{hvt.results}{List. A list of hvt.results obtained from the HVT
function.}
}
\description{
To generate cell id for the multivariate data, the data is being projected from n-dimensions to 1-dimension 
and the cell id is being assigned by ordering these values and finding the corresponding indexes. The output CellID gets
appended to the HVT model.
}
\details{
Cell ID
}
\examples{
data(USArrests)
hvt.results <- list()
hvt.results <- HVT(USArrests, n_cells = 15, depth = 1, quant.err = 0.2, 
                   distance_metric = "L1_Norm", error_metric = "mean",
                   projection.scale = 10, normalize = TRUE,
                   quant_method="kmeans",diagnose=TRUE)
plotHVT(hvt.results, line.width = c(0.8), color.vec = c('#141B41'), 
        maxDepth = 1)
get_cell_id (hvt.results)
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
