% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdm.R
\name{stepwise.backward}
\alias{stepwise.backward}
\title{Stepise backward non-exhaustive greedy search, calculates the optimum value of the discount factor.}
\usage{
stepwise.backward(Data, node, nbf = 15, delta = seq(0.5, 1, 0.01),
  max.break = TRUE, priors = priors.spec())
}
\arguments{
\item{Data}{Dataset with dimension number of time points \code{T} x number of nodes \code{Nn}.}

\item{node}{The node to find parents for.}

\item{nbf}{The Log Predictive Likelihood will sum from (and including) this time point.}

\item{delta}{A vector of values for the discount factor.}

\item{max.break}{If \code{TRUE}, the code will break if adding / removing parents does not
improve the LPL. If \code{FALSE}, the code will continue to the zero parent / all parent model.
Default is \code{TRUE}.}

\item{priors}{List with prior hyperparameters.}
}
\value{
model.store The parents, LPL and chosen discount factor for the subset of models scored using this method.
}
\description{
Stepise backward non-exhaustive greedy search, calculates the optimum value of the discount factor.
}
