% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmult_S3methods.R
\name{print.summary.bmult}
\alias{print.summary.bmult}
\title{print method for class \code{summary.bmult}}
\usage{
\method{print}{summary.bmult}(x, ...)
}
\arguments{
\item{x}{object of class \code{bmult} or \code{summary.bmult} as returned from \code{\link{summary.bmult}}}

\item{...}{additional arguments, currently ignored}
}
\value{
The print methods print the summary from the Bayes factor analysis and returns nothing
}
\description{
Prints the summary from Bayes factor analysis
}
\examples{
# data
x <- c(3, 4, 10, 11)
n <- c(15, 12, 12, 12)
# priors
a <- c(1, 1, 1, 1)
b <- c(1, 1, 1, 1)
# informed hypothesis
factor_levels <- c('theta1', 'theta2', 'theta3', 'theta4')
Hr            <- c('theta1', '<',  'theta2', '<', 'theta3', '<', 'theta4')

## Binomial Case
out_binom  <- binom_bf_informed(x=x, n=n, Hr=Hr, a=a, b=b, niter=1e3,factor_levels, seed=2020)
summary(out_binom)
## Multinomial Case
out_mult  <- mult_bf_informed(x=x, Hr=Hr, a=a, niter=1e3,factor_levels, seed=2020)
summary(out_mult)
}
