% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddsc_ml.R
\name{ddsc_ml}
\alias{ddsc_ml}
\title{Deconstructing difference score correlation with multi-level modeling}
\usage{
ddsc_ml(
  model = NULL,
  data = NULL,
  predictor,
  moderator,
  moderator_values,
  DV = NULL,
  lvl2_unit = NULL,
  re_cov_test = FALSE,
  var_boot_test = FALSE,
  nsim = NULL,
  level = 0.95,
  seed = NULL,
  covariates = NULL,
  scaling_sd = "observed"
)
}
\arguments{
\item{model}{Multilevel model fitted with lmerTest.}

\item{data}{Data frame.}

\item{predictor}{Character string. Variable name of independent variable predicting difference score (i.e., x).}

\item{moderator}{Character string. Variable name indicative of difference score components (w).}

\item{moderator_values}{Vector. Values of the component score groups in moderator (i.e., y1 and y2).}

\item{DV}{Character string. Name of the dependent variable (if model is not supplied as input).}

\item{lvl2_unit}{Character string. Name of the level-2 clustering variable (if model is not supplied as input).}

\item{re_cov_test}{Logical. Significance test for random effect covariation? (Default FALSE)}

\item{var_boot_test}{Logical. Compare variance by lower-level groups at the upper-level in a reduced model with bootstrap? (Default FALSE)}

\item{nsim}{Numeric. Number of bootstrap simulations.}

\item{level}{Numeric. The confidence level required for the var_boot_test output (Default .95)}

\item{seed}{Numeric. Seed number for bootstrap simulations.}

\item{covariates}{Character string or vector. Variable names of covariates (Default NULL).}

\item{scaling_sd}{Character string (either default "observed" or "model"). Are the simple slopes scaled with observed or model-based SDs?}
}
\value{
\item{results}{Summary of key results.}
\item{descriptives}{Means, standard deviations, and intercorrelations at level 2.}
\item{vpc_at_moderator_values}{Variance partition coefficients for moderator values in the model without the predictor and interactions.}
\item{model}{Fitted lmer object.}
\item{reduced_model}{Fitted lmer object without the predictor.}
\item{lvl2_data}{Data summarized at level 2.}
\item{ddsc_sem_fit}{ddsc_sem object fitted to level 2 data.}
\item{re_cov_test}{Likelihood ratio significance test for random effect covariation.}
\item{boot_var_diffs}{List of different variance bootstrap tests.}
}
\description{
Can be used for either pre-fitted lmer-models or to long format data.
}
\examples{
\dontrun{
set.seed(95332)
n1 <- 10 # groups
n2 <- 10 # observations per group
dat <- data.frame(
  group = rep(c(LETTERS[1:n1]), each = n2),
  w = sample(c(-0.5, 0.5), n1 * n2, replace = TRUE),
  x = rep(sample(1:5, n1, replace = TRUE), each = n2),
  y = sample(1:5, n1 * n2, replace = TRUE)
)
library(lmerTest)
fit <- lmerTest::lmer(y ~ x * w + (w | group),
                      data = dat
)
round(ddsc_ml(model=fit,
              predictor="x",
              moderator="w",
              moderator_values=c(0.5,-0.5))$results,3)

round(ddsc_ml(data=dat,
              DV="y",
              lvl2_unit="group",
              predictor="x",
              moderator="w",
              moderator_values=c(0.5,-0.5))$results,3)

}
}
