% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/loadingsplotXY.R
\name{loadingsplotXY}
\alias{loadingsplotXY}
\title{loadings plot of X and Y}
\usage{
loadingsplotXY(X, Y, axes = c(1, 2), INERTIE = NULL, cex = NULL,
  font.lab = NULL)
}
\arguments{
\item{X}{common loadingsassociated with X}

\item{Y}{common loadingsassociated with Y}

\item{axes}{a vector of two selected components}

\item{INERTIE}{if there is information about inertia}

\item{cex}{character expansion for text by default .85}

\item{font.lab}{type of font by default 3}
}
\value{
loadings plot
}
\description{
plots of variables (loadings)
}
\examples{
data(oliveoil)
DataX = oliveoil[,2:6]
DataY = oliveoil[,7:12]
Group = as.factor(oliveoil[,1])
res.mgPLS = mgPLS (DataX, DataY, Group)
X=res.mgPLS$loadings.commo$X; Y=res.mgPLS$loadings.commo$Y
loadingsplotXY(X, Y, axes=c(1,2), INERTIE=res.mgPLS$noncumper.inertiglobal)
}

