% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compilr-methods.R
\name{mean.compilr}
\alias{mean.compilr}
\title{Mean amounts and mean compositions presented in a \code{compilr} object.}
\usage{
\method{mean}{compilr}(
  x,
  ...,
  class = c("composition", "logratio"),
  level = c("between", "within", "total"),
  weight = c("equal", "proportional"),
  digits = 3
)
}
\arguments{
\item{x}{An object of class \code{compilr}.}

\item{...}{generic argument, not in use.}

\item{class}{Optional. Can be \code{"composition"} and/or \code{"logratio"} to
specify the geometry of the composition.}

\item{level}{Optional. Can be \code{"between"}, \code{"within"}, and/or \code{total}
indicating the level of the geometry.}

\item{weight}{A character value specifying the weight to use in calculation of the reference composition.
If \code{"equal"}, give equal weight to units (e.g., individuals).
If \code{"proportional"}, weights in proportion to the frequencies of units being averaged
(e.g., observations across individuals)
Default is \code{equal}.}

\item{digits}{A integer value used for number formatting. Default is \code{3}.}
}
\description{
Mean amounts and mean compositions presented in a \code{compilr} object.
}
\examples{
cilr <- compilr(data = mcompd, sbp = sbp, 
                parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), 
                idvar = "ID")
mean(cilr)
}
