% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Closed.R
\name{getprobsClosed}
\alias{getprobsClosed}
\title{Calculate posterior capture and recapture probabilities}
\usage{
getprobsClosed(out, link = "logit")
}
\arguments{
\item{out}{List of output returned by \code{\link{multimarkClosed}}.}

\item{link}{Link function for detection probability. Must be "\code{logit}" or "\code{probit}". Note that \code{\link{multimarkClosed}} is currently implemented for the logit link only.}
}
\value{
An object of class \code{\link[coda]{mcmc.list}} containing the following:
\item{p}{Posterior samples for capture probability (\eqn{p}) for each sampling occasion.}
\item{c}{Posterior samples for recapture probability (\eqn{c}) for each sampling occasion.}
}
\description{
This function calculates posterior capture (\eqn{p}) and recapture (\eqn{c}) probabilities for each sampling occasion from \code{\link{multimarkClosed}} output.
}
\examples{
\dontshow{
test<-getprobsClosed(multimarkClosed(Enc.Mat=bobcat,data.type="never",iter=10,burnin=0,bin=5))}
\donttest{
# This example is excluded from testing to reduce package check time
# Example uses unrealistically low values for nchain, iter, and burnin

#Run behavior model for bobcat data with constant detection probability (i.e., mod.p=~c)
bobcat.c <- multimarkClosed(bobcat,mod.p=~c)
  
#Calculate capture and recapture probabilities
pc <- getprobsClosed(bobcat.c)
summary(pc)}

}
\seealso{
\code{\link{multimarkClosed}}
}
\author{
Brett T. McClintock
}
