// Generated by rstantools.  Do not edit by hand.

/*
    multinma is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    multinma is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with multinma.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_binomial_2par_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_binomial_2par");
    reader.add_event(1, 1, "include", "/include/prior_select.stan");
    reader.add_event(1, 0, "start", "/include/prior_select.stan");
    reader.add_event(23, 22, "end", "/include/prior_select.stan");
    reader.add_event(23, 2, "restart", "model_binomial_2par");
    reader.add_event(23, 2, "include", "/include/count_nonzero.stan");
    reader.add_event(23, 0, "start", "/include/count_nonzero.stan");
    reader.add_event(35, 12, "end", "/include/count_nonzero.stan");
    reader.add_event(35, 3, "restart", "model_binomial_2par");
    reader.add_event(37, 5, "include", "/include/data_common.stan");
    reader.add_event(37, 0, "start", "/include/data_common.stan");
    reader.add_event(109, 72, "end", "/include/data_common.stan");
    reader.add_event(109, 6, "restart", "model_binomial_2par");
    reader.add_event(116, 13, "include", "/include/transformed_data_common.stan");
    reader.add_event(116, 0, "start", "/include/transformed_data_common.stan");
    reader.add_event(183, 67, "end", "/include/transformed_data_common.stan");
    reader.add_event(183, 14, "restart", "model_binomial_2par");
    reader.add_event(185, 16, "include", "/include/parameters_common.stan");
    reader.add_event(185, 0, "start", "/include/parameters_common.stan");
    reader.add_event(192, 7, "end", "/include/parameters_common.stan");
    reader.add_event(192, 17, "restart", "model_binomial_2par");
    reader.add_event(197, 22, "include", "/include/transformed_parameters_theta.stan");
    reader.add_event(197, 0, "start", "/include/transformed_parameters_theta.stan");
    reader.add_event(202, 5, "end", "/include/transformed_parameters_theta.stan");
    reader.add_event(202, 23, "restart", "model_binomial_2par");
    reader.add_event(202, 23, "include", "/include/transformed_parameters_common.stan");
    reader.add_event(202, 0, "start", "/include/transformed_parameters_common.stan");
    reader.add_event(324, 122, "end", "/include/transformed_parameters_common.stan");
    reader.add_event(324, 24, "restart", "model_binomial_2par");
    reader.add_event(447, 147, "include", "/include/model_common.stan");
    reader.add_event(447, 0, "start", "/include/model_common.stan");
    reader.add_event(488, 41, "end", "/include/model_common.stan");
    reader.add_event(488, 148, "restart", "model_binomial_2par");
    reader.add_event(509, 169, "include", "/include/generated_quantities_theta_fitted.stan");
    reader.add_event(509, 0, "start", "/include/generated_quantities_theta_fitted.stan");
    reader.add_event(515, 6, "end", "/include/generated_quantities_theta_fitted.stan");
    reader.add_event(515, 170, "restart", "model_binomial_2par");
    reader.add_event(515, 170, "include", "/include/generated_quantities_common.stan");
    reader.add_event(515, 0, "start", "/include/generated_quantities_common.stan");
    reader.add_event(573, 58, "end", "/include/generated_quantities_common.stan");
    reader.add_event(573, 171, "restart", "model_binomial_2par");
    reader.add_event(573, 171, "include", "/include/generated_quantities_theta.stan");
    reader.add_event(573, 0, "start", "/include/generated_quantities_theta.stan");
    reader.add_event(582, 9, "end", "/include/generated_quantities_theta.stan");
    reader.add_event(582, 172, "restart", "model_binomial_2par");
    reader.add_event(610, 198, "end", "model_binomial_2par");
    return reader;
}
template <typename T0__, typename T2__, typename T3__, typename T4__, typename T_lp__, typename T_lp_accum__>
void
prior_select_lp(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const int& dist,
                    const T2__& location,
                    const T3__& scale,
                    const T4__& df, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T2__, T3__, T4__, T_lp__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 4;
        if (as_bool(logical_eq(dist, 0))) {
        } else if (as_bool(logical_eq(dist, 1))) {
            current_statement_begin__ = 7;
            lp_accum__.add(normal_log<propto__>(y, location, scale));
        } else if (as_bool(logical_eq(dist, 2))) {
            current_statement_begin__ = 9;
            lp_accum__.add(cauchy_log<propto__>(y, location, scale));
        } else if (as_bool(logical_eq(dist, 3))) {
            current_statement_begin__ = 11;
            lp_accum__.add(student_t_log<propto__>(y, df, location, scale));
        } else if (as_bool(logical_eq(dist, 4))) {
            current_statement_begin__ = 13;
            lp_accum__.add(exponential_log<propto__>(y, (1 / scale)));
        } else if (as_bool(logical_eq(dist, 5))) {
            current_statement_begin__ = 15;
            lp_accum__.add(lognormal_log<propto__>(y, location, scale));
        } else if (as_bool(logical_eq(dist, 6))) {
            current_statement_begin__ = 17;
            lp_accum__.add(student_t_log<propto__>(stan::math::log(y), df, location, scale));
            current_statement_begin__ = 18;
            lp_accum__.add(minus(stan::math::log(y)));
        } else {
            current_statement_begin__ = 20;
            std::stringstream errmsg_stream__;
            errmsg_stream__ << "Not a supported prior dist.";
            throw std::domain_error(errmsg_stream__.str());
        }
        current_statement_begin__ = 22;
        return ;
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct prior_select_lp_functor__ {
    template <typename T0__, typename T2__, typename T3__, typename T4__, typename T_lp__, typename T_lp_accum__>
        void
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, 1>& y,
                    const int& dist,
                    const T2__& location,
                    const T3__& scale,
                    const T4__& df, T_lp__& lp__, T_lp_accum__& lp_accum__, std::ostream* pstream__) const {
        return prior_select_lp(y, dist, location, scale, df, lp__, lp_accum__, pstream__);
    }
};
template <typename T0__>
int
count_nonzero(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& m, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 26;
        int I(0);
        (void) I;  // dummy to suppress unused var warning
        stan::math::fill(I, std::numeric_limits<int>::min());
        stan::math::assign(I,rows(m));
        current_statement_begin__ = 27;
        int J(0);
        (void) J;  // dummy to suppress unused var warning
        stan::math::fill(J, std::numeric_limits<int>::min());
        stan::math::assign(J,cols(m));
        current_statement_begin__ = 28;
        int c(0);
        (void) c;  // dummy to suppress unused var warning
        stan::math::fill(c, std::numeric_limits<int>::min());
        stan::math::assign(c,0);
        current_statement_begin__ = 29;
        for (int j = 1; j <= I; ++j) {
            current_statement_begin__ = 30;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 31;
                if (as_bool(logical_neq(get_base1(m, i, j, "m", 1), 0))) {
                    current_statement_begin__ = 31;
                    stan::math::assign(c, (c + 1));
                }
            }
        }
        current_statement_begin__ = 34;
        return stan::math::promote_scalar<fun_return_scalar_t__>(c);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct count_nonzero_functor__ {
    template <typename T0__>
        int
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& m, std::ostream* pstream__) const {
        return count_nonzero(m, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_binomial_2par
  : public stan::model::model_base_crtp<model_binomial_2par> {
private:
        int ns_ipd;
        int ns_agd_arm;
        int ns_agd_contrast;
        int ni_ipd;
        int ni_agd_arm;
        int ni_agd_contrast;
        int narm_ipd;
        std::vector<int> ipd_arm;
        std::vector<int> ipd_trt;
        std::vector<int> agd_arm_trt;
        std::vector<int> agd_contrast_trt;
        std::vector<int> agd_contrast_trt_b;
        int nt;
        int nX;
        int nint;
        int int_thin;
        int link;
        vector_d agd_contrast_y;
        matrix_d agd_contrast_Sigma;
        int QR;
        matrix_d X;
        matrix_d R_inv;
        int has_offset;
        vector_d offsets;
        int RE;
        std::vector<int> which_RE;
        matrix_d RE_cor;
        int nodesplit;
        int prior_intercept_dist;
        double prior_intercept_location;
        double prior_intercept_scale;
        double prior_intercept_df;
        int prior_trt_dist;
        double prior_trt_location;
        double prior_trt_scale;
        double prior_trt_df;
        int prior_het_dist;
        int prior_het_type;
        double prior_het_location;
        double prior_het_scale;
        double prior_het_df;
        int prior_reg_dist;
        double prior_reg_location;
        double prior_reg_scale;
        double prior_reg_df;
        std::vector<int> ipd_r;
        std::vector<int> agd_arm_n;
        std::vector<int> agd_arm_r;
        int n_delta;
        vector_d RE_mu;
        matrix_d REdummy;
        matrix_d RE_L;
        vector_d wdummy;
        std::vector<int> vudummy;
        int RE_L_nz;
        int RE_sparse;
        vector_d RE_L_w;
        std::vector<int> RE_L_v;
        std::vector<int> RE_L_u;
        int totni;
        int totns;
        std::vector<int> trt;
        matrix_d Xdummy;
        matrix_d X_ipd;
        matrix_d X_agd_arm;
        matrix_d X_agd_contrast;
        vector_d odummy;
        vector_d offset_ipd;
        vector_d offset_agd_arm;
        vector_d offset_agd_contrast;
        int n_int_thin;
        matrix_d inv_Sigma;
        std::vector<int> nc_agd_contrast;
public:
    model_binomial_2par(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_binomial_2par(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_binomial_2par_namespace::model_binomial_2par";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "ns_ipd", "int", context__.to_vec());
            ns_ipd = int(0);
            vals_i__ = context__.vals_i("ns_ipd");
            pos__ = 0;
            ns_ipd = vals_i__[pos__++];
            check_greater_or_equal(function__, "ns_ipd", ns_ipd, 0);
            current_statement_begin__ = 41;
            context__.validate_dims("data initialization", "ns_agd_arm", "int", context__.to_vec());
            ns_agd_arm = int(0);
            vals_i__ = context__.vals_i("ns_agd_arm");
            pos__ = 0;
            ns_agd_arm = vals_i__[pos__++];
            check_greater_or_equal(function__, "ns_agd_arm", ns_agd_arm, 0);
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "ns_agd_contrast", "int", context__.to_vec());
            ns_agd_contrast = int(0);
            vals_i__ = context__.vals_i("ns_agd_contrast");
            pos__ = 0;
            ns_agd_contrast = vals_i__[pos__++];
            check_greater_or_equal(function__, "ns_agd_contrast", ns_agd_contrast, 0);
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "ni_ipd", "int", context__.to_vec());
            ni_ipd = int(0);
            vals_i__ = context__.vals_i("ni_ipd");
            pos__ = 0;
            ni_ipd = vals_i__[pos__++];
            check_greater_or_equal(function__, "ni_ipd", ni_ipd, 0);
            current_statement_begin__ = 45;
            context__.validate_dims("data initialization", "ni_agd_arm", "int", context__.to_vec());
            ni_agd_arm = int(0);
            vals_i__ = context__.vals_i("ni_agd_arm");
            pos__ = 0;
            ni_agd_arm = vals_i__[pos__++];
            check_greater_or_equal(function__, "ni_agd_arm", ni_agd_arm, 0);
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "ni_agd_contrast", "int", context__.to_vec());
            ni_agd_contrast = int(0);
            vals_i__ = context__.vals_i("ni_agd_contrast");
            pos__ = 0;
            ni_agd_contrast = vals_i__[pos__++];
            check_greater_or_equal(function__, "ni_agd_contrast", ni_agd_contrast, 0);
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "narm_ipd", "int", context__.to_vec());
            narm_ipd = int(0);
            vals_i__ = context__.vals_i("narm_ipd");
            pos__ = 0;
            narm_ipd = vals_i__[pos__++];
            check_greater_or_equal(function__, "narm_ipd", narm_ipd, 0);
            current_statement_begin__ = 50;
            validate_non_negative_index("ipd_arm", "ni_ipd", ni_ipd);
            context__.validate_dims("data initialization", "ipd_arm", "int", context__.to_vec(ni_ipd));
            ipd_arm = std::vector<int>(ni_ipd, int(0));
            vals_i__ = context__.vals_i("ipd_arm");
            pos__ = 0;
            size_t ipd_arm_k_0_max__ = ni_ipd;
            for (size_t k_0__ = 0; k_0__ < ipd_arm_k_0_max__; ++k_0__) {
                ipd_arm[k_0__] = vals_i__[pos__++];
            }
            size_t ipd_arm_i_0_max__ = ni_ipd;
            for (size_t i_0__ = 0; i_0__ < ipd_arm_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ipd_arm[i_0__]", ipd_arm[i_0__], 1);
            }
            current_statement_begin__ = 51;
            validate_non_negative_index("ipd_trt", "narm_ipd", narm_ipd);
            context__.validate_dims("data initialization", "ipd_trt", "int", context__.to_vec(narm_ipd));
            ipd_trt = std::vector<int>(narm_ipd, int(0));
            vals_i__ = context__.vals_i("ipd_trt");
            pos__ = 0;
            size_t ipd_trt_k_0_max__ = narm_ipd;
            for (size_t k_0__ = 0; k_0__ < ipd_trt_k_0_max__; ++k_0__) {
                ipd_trt[k_0__] = vals_i__[pos__++];
            }
            size_t ipd_trt_i_0_max__ = narm_ipd;
            for (size_t i_0__ = 0; i_0__ < ipd_trt_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ipd_trt[i_0__]", ipd_trt[i_0__], 1);
            }
            current_statement_begin__ = 52;
            validate_non_negative_index("agd_arm_trt", "ni_agd_arm", ni_agd_arm);
            context__.validate_dims("data initialization", "agd_arm_trt", "int", context__.to_vec(ni_agd_arm));
            agd_arm_trt = std::vector<int>(ni_agd_arm, int(0));
            vals_i__ = context__.vals_i("agd_arm_trt");
            pos__ = 0;
            size_t agd_arm_trt_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < agd_arm_trt_k_0_max__; ++k_0__) {
                agd_arm_trt[k_0__] = vals_i__[pos__++];
            }
            size_t agd_arm_trt_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < agd_arm_trt_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "agd_arm_trt[i_0__]", agd_arm_trt[i_0__], 1);
            }
            current_statement_begin__ = 53;
            validate_non_negative_index("agd_contrast_trt", "ni_agd_contrast", ni_agd_contrast);
            context__.validate_dims("data initialization", "agd_contrast_trt", "int", context__.to_vec(ni_agd_contrast));
            agd_contrast_trt = std::vector<int>(ni_agd_contrast, int(0));
            vals_i__ = context__.vals_i("agd_contrast_trt");
            pos__ = 0;
            size_t agd_contrast_trt_k_0_max__ = ni_agd_contrast;
            for (size_t k_0__ = 0; k_0__ < agd_contrast_trt_k_0_max__; ++k_0__) {
                agd_contrast_trt[k_0__] = vals_i__[pos__++];
            }
            size_t agd_contrast_trt_i_0_max__ = ni_agd_contrast;
            for (size_t i_0__ = 0; i_0__ < agd_contrast_trt_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "agd_contrast_trt[i_0__]", agd_contrast_trt[i_0__], 1);
            }
            current_statement_begin__ = 54;
            validate_non_negative_index("agd_contrast_trt_b", "ni_agd_contrast", ni_agd_contrast);
            context__.validate_dims("data initialization", "agd_contrast_trt_b", "int", context__.to_vec(ni_agd_contrast));
            agd_contrast_trt_b = std::vector<int>(ni_agd_contrast, int(0));
            vals_i__ = context__.vals_i("agd_contrast_trt_b");
            pos__ = 0;
            size_t agd_contrast_trt_b_k_0_max__ = ni_agd_contrast;
            for (size_t k_0__ = 0; k_0__ < agd_contrast_trt_b_k_0_max__; ++k_0__) {
                agd_contrast_trt_b[k_0__] = vals_i__[pos__++];
            }
            size_t agd_contrast_trt_b_i_0_max__ = ni_agd_contrast;
            for (size_t i_0__ = 0; i_0__ < agd_contrast_trt_b_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "agd_contrast_trt_b[i_0__]", agd_contrast_trt_b[i_0__], 1);
            }
            current_statement_begin__ = 61;
            context__.validate_dims("data initialization", "nt", "int", context__.to_vec());
            nt = int(0);
            vals_i__ = context__.vals_i("nt");
            pos__ = 0;
            nt = vals_i__[pos__++];
            check_greater_or_equal(function__, "nt", nt, 1);
            current_statement_begin__ = 62;
            context__.validate_dims("data initialization", "nX", "int", context__.to_vec());
            nX = int(0);
            vals_i__ = context__.vals_i("nX");
            pos__ = 0;
            nX = vals_i__[pos__++];
            check_greater_or_equal(function__, "nX", nX, 0);
            current_statement_begin__ = 63;
            context__.validate_dims("data initialization", "nint", "int", context__.to_vec());
            nint = int(0);
            vals_i__ = context__.vals_i("nint");
            pos__ = 0;
            nint = vals_i__[pos__++];
            check_greater_or_equal(function__, "nint", nint, 1);
            current_statement_begin__ = 64;
            context__.validate_dims("data initialization", "int_thin", "int", context__.to_vec());
            int_thin = int(0);
            vals_i__ = context__.vals_i("int_thin");
            pos__ = 0;
            int_thin = vals_i__[pos__++];
            check_greater_or_equal(function__, "int_thin", int_thin, 1);
            current_statement_begin__ = 66;
            context__.validate_dims("data initialization", "link", "int", context__.to_vec());
            link = int(0);
            vals_i__ = context__.vals_i("link");
            pos__ = 0;
            link = vals_i__[pos__++];
            check_greater_or_equal(function__, "link", link, 1);
            current_statement_begin__ = 69;
            validate_non_negative_index("agd_contrast_y", "ni_agd_contrast", ni_agd_contrast);
            context__.validate_dims("data initialization", "agd_contrast_y", "vector_d", context__.to_vec(ni_agd_contrast));
            agd_contrast_y = Eigen::Matrix<double, Eigen::Dynamic, 1>(ni_agd_contrast);
            vals_r__ = context__.vals_r("agd_contrast_y");
            pos__ = 0;
            size_t agd_contrast_y_j_1_max__ = ni_agd_contrast;
            for (size_t j_1__ = 0; j_1__ < agd_contrast_y_j_1_max__; ++j_1__) {
                agd_contrast_y(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 70;
            validate_non_negative_index("agd_contrast_Sigma", "(ni_agd_contrast ? ni_agd_contrast : 1 )", (ni_agd_contrast ? ni_agd_contrast : 1 ));
            validate_non_negative_index("agd_contrast_Sigma", "(ni_agd_contrast ? ni_agd_contrast : 1 )", (ni_agd_contrast ? ni_agd_contrast : 1 ));
            context__.validate_dims("data initialization", "agd_contrast_Sigma", "matrix_d", context__.to_vec((ni_agd_contrast ? ni_agd_contrast : 1 ),(ni_agd_contrast ? ni_agd_contrast : 1 )));
            agd_contrast_Sigma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((ni_agd_contrast ? ni_agd_contrast : 1 ), (ni_agd_contrast ? ni_agd_contrast : 1 ));
            vals_r__ = context__.vals_r("agd_contrast_Sigma");
            pos__ = 0;
            size_t agd_contrast_Sigma_j_2_max__ = (ni_agd_contrast ? ni_agd_contrast : 1 );
            size_t agd_contrast_Sigma_j_1_max__ = (ni_agd_contrast ? ni_agd_contrast : 1 );
            for (size_t j_2__ = 0; j_2__ < agd_contrast_Sigma_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < agd_contrast_Sigma_j_1_max__; ++j_1__) {
                    agd_contrast_Sigma(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            stan::math::check_cov_matrix(function__, "agd_contrast_Sigma", agd_contrast_Sigma);
            current_statement_begin__ = 73;
            context__.validate_dims("data initialization", "QR", "int", context__.to_vec());
            QR = int(0);
            vals_i__ = context__.vals_i("QR");
            pos__ = 0;
            QR = vals_i__[pos__++];
            check_greater_or_equal(function__, "QR", QR, 0);
            check_less_or_equal(function__, "QR", QR, 1);
            current_statement_begin__ = 74;
            validate_non_negative_index("X", "(ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast)))", (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))));
            validate_non_negative_index("X", "nX", nX);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec((ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))),nX));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))), nX);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = nX;
            size_t X_j_1_max__ = (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast)));
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 75;
            validate_non_negative_index("R_inv", "(QR ? nX : 0 )", (QR ? nX : 0 ));
            validate_non_negative_index("R_inv", "(QR ? nX : 0 )", (QR ? nX : 0 ));
            context__.validate_dims("data initialization", "R_inv", "matrix_d", context__.to_vec((QR ? nX : 0 ),(QR ? nX : 0 )));
            R_inv = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((QR ? nX : 0 ), (QR ? nX : 0 ));
            vals_r__ = context__.vals_r("R_inv");
            pos__ = 0;
            size_t R_inv_j_2_max__ = (QR ? nX : 0 );
            size_t R_inv_j_1_max__ = (QR ? nX : 0 );
            for (size_t j_2__ = 0; j_2__ < R_inv_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < R_inv_j_1_max__; ++j_1__) {
                    R_inv(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 78;
            context__.validate_dims("data initialization", "has_offset", "int", context__.to_vec());
            has_offset = int(0);
            vals_i__ = context__.vals_i("has_offset");
            pos__ = 0;
            has_offset = vals_i__[pos__++];
            check_greater_or_equal(function__, "has_offset", has_offset, 0);
            check_less_or_equal(function__, "has_offset", has_offset, 1);
            current_statement_begin__ = 79;
            validate_non_negative_index("offsets", "(has_offset ? (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))) : 0 )", (has_offset ? (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))) : 0 ));
            context__.validate_dims("data initialization", "offsets", "vector_d", context__.to_vec((has_offset ? (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))) : 0 )));
            offsets = Eigen::Matrix<double, Eigen::Dynamic, 1>((has_offset ? (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))) : 0 ));
            vals_r__ = context__.vals_r("offsets");
            pos__ = 0;
            size_t offsets_j_1_max__ = (has_offset ? (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))) : 0 );
            for (size_t j_1__ = 0; j_1__ < offsets_j_1_max__; ++j_1__) {
                offsets(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 82;
            context__.validate_dims("data initialization", "RE", "int", context__.to_vec());
            RE = int(0);
            vals_i__ = context__.vals_i("RE");
            pos__ = 0;
            RE = vals_i__[pos__++];
            check_greater_or_equal(function__, "RE", RE, 0);
            check_less_or_equal(function__, "RE", RE, 1);
            current_statement_begin__ = 83;
            validate_non_negative_index("which_RE", "(RE ? ((narm_ipd + ni_agd_arm) + ni_agd_contrast) : 0 )", (RE ? ((narm_ipd + ni_agd_arm) + ni_agd_contrast) : 0 ));
            context__.validate_dims("data initialization", "which_RE", "int", context__.to_vec((RE ? ((narm_ipd + ni_agd_arm) + ni_agd_contrast) : 0 )));
            which_RE = std::vector<int>((RE ? ((narm_ipd + ni_agd_arm) + ni_agd_contrast) : 0 ), int(0));
            vals_i__ = context__.vals_i("which_RE");
            pos__ = 0;
            size_t which_RE_k_0_max__ = (RE ? ((narm_ipd + ni_agd_arm) + ni_agd_contrast) : 0 );
            for (size_t k_0__ = 0; k_0__ < which_RE_k_0_max__; ++k_0__) {
                which_RE[k_0__] = vals_i__[pos__++];
            }
            size_t which_RE_i_0_max__ = (RE ? ((narm_ipd + ni_agd_arm) + ni_agd_contrast) : 0 );
            for (size_t i_0__ = 0; i_0__ < which_RE_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "which_RE[i_0__]", which_RE[i_0__], 0);
            }
            current_statement_begin__ = 84;
            validate_non_negative_index("RE_cor", "(RE ? max(which_RE) : 1 )", (RE ? max(which_RE) : 1 ));
            validate_non_negative_index("RE_cor", "(RE ? max(which_RE) : 1 )", (RE ? max(which_RE) : 1 ));
            context__.validate_dims("data initialization", "RE_cor", "matrix_d", context__.to_vec((RE ? max(which_RE) : 1 ),(RE ? max(which_RE) : 1 )));
            RE_cor = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((RE ? max(which_RE) : 1 ), (RE ? max(which_RE) : 1 ));
            vals_r__ = context__.vals_r("RE_cor");
            pos__ = 0;
            size_t RE_cor_j_2_max__ = (RE ? max(which_RE) : 1 );
            size_t RE_cor_j_1_max__ = (RE ? max(which_RE) : 1 );
            for (size_t j_2__ = 0; j_2__ < RE_cor_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < RE_cor_j_1_max__; ++j_1__) {
                    RE_cor(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            stan::math::check_corr_matrix(function__, "RE_cor", RE_cor);
            current_statement_begin__ = 87;
            context__.validate_dims("data initialization", "nodesplit", "int", context__.to_vec());
            nodesplit = int(0);
            vals_i__ = context__.vals_i("nodesplit");
            pos__ = 0;
            nodesplit = vals_i__[pos__++];
            check_greater_or_equal(function__, "nodesplit", nodesplit, 0);
            check_less_or_equal(function__, "nodesplit", nodesplit, 1);
            current_statement_begin__ = 90;
            context__.validate_dims("data initialization", "prior_intercept_dist", "int", context__.to_vec());
            prior_intercept_dist = int(0);
            vals_i__ = context__.vals_i("prior_intercept_dist");
            pos__ = 0;
            prior_intercept_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_intercept_dist", prior_intercept_dist, 0);
            check_less_or_equal(function__, "prior_intercept_dist", prior_intercept_dist, 3);
            current_statement_begin__ = 91;
            context__.validate_dims("data initialization", "prior_intercept_location", "double", context__.to_vec());
            prior_intercept_location = double(0);
            vals_r__ = context__.vals_r("prior_intercept_location");
            pos__ = 0;
            prior_intercept_location = vals_r__[pos__++];
            current_statement_begin__ = 92;
            context__.validate_dims("data initialization", "prior_intercept_scale", "double", context__.to_vec());
            prior_intercept_scale = double(0);
            vals_r__ = context__.vals_r("prior_intercept_scale");
            pos__ = 0;
            prior_intercept_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_intercept_scale", prior_intercept_scale, 0);
            current_statement_begin__ = 93;
            context__.validate_dims("data initialization", "prior_intercept_df", "double", context__.to_vec());
            prior_intercept_df = double(0);
            vals_r__ = context__.vals_r("prior_intercept_df");
            pos__ = 0;
            prior_intercept_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_intercept_df", prior_intercept_df, 0);
            current_statement_begin__ = 95;
            context__.validate_dims("data initialization", "prior_trt_dist", "int", context__.to_vec());
            prior_trt_dist = int(0);
            vals_i__ = context__.vals_i("prior_trt_dist");
            pos__ = 0;
            prior_trt_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_trt_dist", prior_trt_dist, 0);
            check_less_or_equal(function__, "prior_trt_dist", prior_trt_dist, 3);
            current_statement_begin__ = 96;
            context__.validate_dims("data initialization", "prior_trt_location", "double", context__.to_vec());
            prior_trt_location = double(0);
            vals_r__ = context__.vals_r("prior_trt_location");
            pos__ = 0;
            prior_trt_location = vals_r__[pos__++];
            current_statement_begin__ = 97;
            context__.validate_dims("data initialization", "prior_trt_scale", "double", context__.to_vec());
            prior_trt_scale = double(0);
            vals_r__ = context__.vals_r("prior_trt_scale");
            pos__ = 0;
            prior_trt_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_trt_scale", prior_trt_scale, 0);
            current_statement_begin__ = 98;
            context__.validate_dims("data initialization", "prior_trt_df", "double", context__.to_vec());
            prior_trt_df = double(0);
            vals_r__ = context__.vals_r("prior_trt_df");
            pos__ = 0;
            prior_trt_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_trt_df", prior_trt_df, 0);
            current_statement_begin__ = 100;
            context__.validate_dims("data initialization", "prior_het_dist", "int", context__.to_vec());
            prior_het_dist = int(0);
            vals_i__ = context__.vals_i("prior_het_dist");
            pos__ = 0;
            prior_het_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_het_dist", prior_het_dist, 0);
            check_less_or_equal(function__, "prior_het_dist", prior_het_dist, 6);
            current_statement_begin__ = 101;
            context__.validate_dims("data initialization", "prior_het_type", "int", context__.to_vec());
            prior_het_type = int(0);
            vals_i__ = context__.vals_i("prior_het_type");
            pos__ = 0;
            prior_het_type = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_het_type", prior_het_type, 1);
            check_less_or_equal(function__, "prior_het_type", prior_het_type, 3);
            current_statement_begin__ = 102;
            context__.validate_dims("data initialization", "prior_het_location", "double", context__.to_vec());
            prior_het_location = double(0);
            vals_r__ = context__.vals_r("prior_het_location");
            pos__ = 0;
            prior_het_location = vals_r__[pos__++];
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "prior_het_scale", "double", context__.to_vec());
            prior_het_scale = double(0);
            vals_r__ = context__.vals_r("prior_het_scale");
            pos__ = 0;
            prior_het_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_het_scale", prior_het_scale, 0);
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "prior_het_df", "double", context__.to_vec());
            prior_het_df = double(0);
            vals_r__ = context__.vals_r("prior_het_df");
            pos__ = 0;
            prior_het_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_het_df", prior_het_df, 0);
            current_statement_begin__ = 106;
            context__.validate_dims("data initialization", "prior_reg_dist", "int", context__.to_vec());
            prior_reg_dist = int(0);
            vals_i__ = context__.vals_i("prior_reg_dist");
            pos__ = 0;
            prior_reg_dist = vals_i__[pos__++];
            check_greater_or_equal(function__, "prior_reg_dist", prior_reg_dist, 0);
            check_less_or_equal(function__, "prior_reg_dist", prior_reg_dist, 3);
            current_statement_begin__ = 107;
            context__.validate_dims("data initialization", "prior_reg_location", "double", context__.to_vec());
            prior_reg_location = double(0);
            vals_r__ = context__.vals_r("prior_reg_location");
            pos__ = 0;
            prior_reg_location = vals_r__[pos__++];
            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "prior_reg_scale", "double", context__.to_vec());
            prior_reg_scale = double(0);
            vals_r__ = context__.vals_r("prior_reg_scale");
            pos__ = 0;
            prior_reg_scale = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_reg_scale", prior_reg_scale, 0);
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "prior_reg_df", "double", context__.to_vec());
            prior_reg_df = double(0);
            vals_r__ = context__.vals_r("prior_reg_df");
            pos__ = 0;
            prior_reg_df = vals_r__[pos__++];
            check_greater_or_equal(function__, "prior_reg_df", prior_reg_df, 0);
            current_statement_begin__ = 112;
            validate_non_negative_index("ipd_r", "ni_ipd", ni_ipd);
            context__.validate_dims("data initialization", "ipd_r", "int", context__.to_vec(ni_ipd));
            ipd_r = std::vector<int>(ni_ipd, int(0));
            vals_i__ = context__.vals_i("ipd_r");
            pos__ = 0;
            size_t ipd_r_k_0_max__ = ni_ipd;
            for (size_t k_0__ = 0; k_0__ < ipd_r_k_0_max__; ++k_0__) {
                ipd_r[k_0__] = vals_i__[pos__++];
            }
            size_t ipd_r_i_0_max__ = ni_ipd;
            for (size_t i_0__ = 0; i_0__ < ipd_r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "ipd_r[i_0__]", ipd_r[i_0__], 0);
                check_less_or_equal(function__, "ipd_r[i_0__]", ipd_r[i_0__], 1);
            }
            current_statement_begin__ = 113;
            validate_non_negative_index("agd_arm_n", "ni_agd_arm", ni_agd_arm);
            context__.validate_dims("data initialization", "agd_arm_n", "int", context__.to_vec(ni_agd_arm));
            agd_arm_n = std::vector<int>(ni_agd_arm, int(0));
            vals_i__ = context__.vals_i("agd_arm_n");
            pos__ = 0;
            size_t agd_arm_n_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < agd_arm_n_k_0_max__; ++k_0__) {
                agd_arm_n[k_0__] = vals_i__[pos__++];
            }
            size_t agd_arm_n_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < agd_arm_n_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "agd_arm_n[i_0__]", agd_arm_n[i_0__], 0);
            }
            current_statement_begin__ = 114;
            validate_non_negative_index("agd_arm_r", "ni_agd_arm", ni_agd_arm);
            context__.validate_dims("data initialization", "agd_arm_r", "int", context__.to_vec(ni_agd_arm));
            agd_arm_r = std::vector<int>(ni_agd_arm, int(0));
            vals_i__ = context__.vals_i("agd_arm_r");
            pos__ = 0;
            size_t agd_arm_r_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < agd_arm_r_k_0_max__; ++k_0__) {
                agd_arm_r[k_0__] = vals_i__[pos__++];
            }
            size_t agd_arm_r_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < agd_arm_r_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "agd_arm_r[i_0__]", agd_arm_r[i_0__], 0);
            }
            // initialize transformed data variables
            current_statement_begin__ = 121;
            n_delta = int(0);
            stan::math::fill(n_delta, std::numeric_limits<int>::min());
            stan::math::assign(n_delta,(RE ? max(which_RE) : 0 ));
            current_statement_begin__ = 123;
            validate_non_negative_index("RE_mu", "n_delta", n_delta);
            RE_mu = Eigen::Matrix<double, Eigen::Dynamic, 1>(n_delta);
            stan::math::fill(RE_mu, DUMMY_VAR__);
            stan::math::assign(RE_mu,rep_vector(0, n_delta));
            current_statement_begin__ = 125;
            validate_non_negative_index("REdummy", "0", 0);
            validate_non_negative_index("REdummy", "0", 0);
            REdummy = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(0, 0);
            stan::math::fill(REdummy, DUMMY_VAR__);
            current_statement_begin__ = 126;
            validate_non_negative_index("RE_L", "n_delta", n_delta);
            validate_non_negative_index("RE_L", "n_delta", n_delta);
            RE_L = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(n_delta, n_delta);
            stan::math::fill(RE_L, DUMMY_VAR__);
            stan::math::assign(RE_L,(n_delta ? stan::math::promote_scalar<double>(cholesky_decompose(RE_cor)) : stan::math::promote_scalar<double>(REdummy) ));
            current_statement_begin__ = 128;
            validate_non_negative_index("wdummy", "0", 0);
            wdummy = Eigen::Matrix<double, Eigen::Dynamic, 1>(0);
            stan::math::fill(wdummy, DUMMY_VAR__);
            current_statement_begin__ = 129;
            validate_non_negative_index("vudummy", "0", 0);
            vudummy = std::vector<int>(0, int(0));
            stan::math::fill(vudummy, std::numeric_limits<int>::min());
            current_statement_begin__ = 130;
            RE_L_nz = int(0);
            stan::math::fill(RE_L_nz, std::numeric_limits<int>::min());
            stan::math::assign(RE_L_nz,count_nonzero(RE_L, pstream__));
            current_statement_begin__ = 131;
            RE_sparse = int(0);
            stan::math::fill(RE_sparse, std::numeric_limits<int>::min());
            stan::math::assign(RE_sparse,logical_lte(((RE_L_nz * 1.0) / num_elements(RE_L)), 0.1));
            current_statement_begin__ = 132;
            validate_non_negative_index("RE_L_w", "(RE_sparse ? RE_L_nz : 0 )", (RE_sparse ? RE_L_nz : 0 ));
            RE_L_w = Eigen::Matrix<double, Eigen::Dynamic, 1>((RE_sparse ? RE_L_nz : 0 ));
            stan::math::fill(RE_L_w, DUMMY_VAR__);
            stan::math::assign(RE_L_w,(RE_sparse ? stan::math::promote_scalar<double>(csr_extract_w(RE_L)) : stan::math::promote_scalar<double>(wdummy) ));
            current_statement_begin__ = 133;
            validate_non_negative_index("RE_L_v", "(RE_sparse ? RE_L_nz : 0 )", (RE_sparse ? RE_L_nz : 0 ));
            RE_L_v = std::vector<int>((RE_sparse ? RE_L_nz : 0 ), int(0));
            stan::math::fill(RE_L_v, std::numeric_limits<int>::min());
            stan::math::assign(RE_L_v,(RE_sparse ? stan::math::promote_scalar<double>(csr_extract_v(RE_L)) : stan::math::promote_scalar<double>(vudummy) ));
            current_statement_begin__ = 134;
            validate_non_negative_index("RE_L_u", "(RE_sparse ? (n_delta + 1) : 0 )", (RE_sparse ? (n_delta + 1) : 0 ));
            RE_L_u = std::vector<int>((RE_sparse ? (n_delta + 1) : 0 ), int(0));
            stan::math::fill(RE_L_u, std::numeric_limits<int>::min());
            stan::math::assign(RE_L_u,(RE_sparse ? stan::math::promote_scalar<double>(csr_extract_u(RE_L)) : stan::math::promote_scalar<double>(vudummy) ));
            current_statement_begin__ = 137;
            totni = int(0);
            stan::math::fill(totni, std::numeric_limits<int>::min());
            stan::math::assign(totni,(ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast))));
            current_statement_begin__ = 140;
            totns = int(0);
            stan::math::fill(totns, std::numeric_limits<int>::min());
            stan::math::assign(totns,(ns_ipd + ns_agd_arm));
            current_statement_begin__ = 146;
            validate_non_negative_index("trt", "((narm_ipd + ni_agd_arm) + ni_agd_contrast)", ((narm_ipd + ni_agd_arm) + ni_agd_contrast));
            trt = std::vector<int>(((narm_ipd + ni_agd_arm) + ni_agd_contrast), int(0));
            stan::math::fill(trt, std::numeric_limits<int>::min());
            stan::math::assign(trt,append_array(append_array(ipd_trt, agd_arm_trt), agd_contrast_trt));
            current_statement_begin__ = 149;
            validate_non_negative_index("Xdummy", "0", 0);
            validate_non_negative_index("Xdummy", "nX", nX);
            Xdummy = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(0, nX);
            stan::math::fill(Xdummy, DUMMY_VAR__);
            current_statement_begin__ = 150;
            validate_non_negative_index("X_ipd", "ni_ipd", ni_ipd);
            validate_non_negative_index("X_ipd", "nX", nX);
            X_ipd = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(ni_ipd, nX);
            stan::math::fill(X_ipd, DUMMY_VAR__);
            stan::math::assign(X_ipd,(ni_ipd ? stan::math::promote_scalar<double>(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_min_max(1, ni_ipd), stan::model::nil_index_list()), "X")) : stan::math::promote_scalar<double>(Xdummy) ));
            current_statement_begin__ = 151;
            validate_non_negative_index("X_agd_arm", "(nint * ni_agd_arm)", (nint * ni_agd_arm));
            validate_non_negative_index("X_agd_arm", "nX", nX);
            X_agd_arm = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((nint * ni_agd_arm), nX);
            stan::math::fill(X_agd_arm, DUMMY_VAR__);
            stan::math::assign(X_agd_arm,(ni_agd_arm ? stan::math::promote_scalar<double>(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_min_max((ni_ipd + 1), (ni_ipd + (nint * ni_agd_arm))), stan::model::nil_index_list()), "X")) : stan::math::promote_scalar<double>(Xdummy) ));
            current_statement_begin__ = 152;
            validate_non_negative_index("X_agd_contrast", "(nint * ni_agd_contrast)", (nint * ni_agd_contrast));
            validate_non_negative_index("X_agd_contrast", "nX", nX);
            X_agd_contrast = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((nint * ni_agd_contrast), nX);
            stan::math::fill(X_agd_contrast, DUMMY_VAR__);
            stan::math::assign(X_agd_contrast,(ni_agd_contrast ? stan::math::promote_scalar<double>(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_min_max(((ni_ipd + (nint * ni_agd_arm)) + 1), (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast)))), stan::model::nil_index_list()), "X")) : stan::math::promote_scalar<double>(Xdummy) ));
            current_statement_begin__ = 155;
            validate_non_negative_index("odummy", "0", 0);
            odummy = Eigen::Matrix<double, Eigen::Dynamic, 1>(0);
            stan::math::fill(odummy, DUMMY_VAR__);
            current_statement_begin__ = 156;
            validate_non_negative_index("offset_ipd", "((primitive_value(has_offset) && primitive_value(ni_ipd)) ? ni_ipd : 0 )", ((primitive_value(has_offset) && primitive_value(ni_ipd)) ? ni_ipd : 0 ));
            offset_ipd = Eigen::Matrix<double, Eigen::Dynamic, 1>(((primitive_value(has_offset) && primitive_value(ni_ipd)) ? ni_ipd : 0 ));
            stan::math::fill(offset_ipd, DUMMY_VAR__);
            stan::math::assign(offset_ipd,((primitive_value(has_offset) && primitive_value(ni_ipd)) ? stan::math::promote_scalar<double>(stan::model::rvalue(offsets, stan::model::cons_list(stan::model::index_min_max(1, ni_ipd), stan::model::nil_index_list()), "offsets")) : stan::math::promote_scalar<double>(odummy) ));
            current_statement_begin__ = 157;
            validate_non_negative_index("offset_agd_arm", "((primitive_value(has_offset) && primitive_value(ni_agd_arm)) ? (nint * ni_agd_arm) : 0 )", ((primitive_value(has_offset) && primitive_value(ni_agd_arm)) ? (nint * ni_agd_arm) : 0 ));
            offset_agd_arm = Eigen::Matrix<double, Eigen::Dynamic, 1>(((primitive_value(has_offset) && primitive_value(ni_agd_arm)) ? (nint * ni_agd_arm) : 0 ));
            stan::math::fill(offset_agd_arm, DUMMY_VAR__);
            stan::math::assign(offset_agd_arm,((primitive_value(has_offset) && primitive_value(ni_agd_arm)) ? stan::math::promote_scalar<double>(stan::model::rvalue(offsets, stan::model::cons_list(stan::model::index_min_max((ni_ipd + 1), (ni_ipd + (nint * ni_agd_arm))), stan::model::nil_index_list()), "offsets")) : stan::math::promote_scalar<double>(odummy) ));
            current_statement_begin__ = 158;
            validate_non_negative_index("offset_agd_contrast", "((primitive_value(has_offset) && primitive_value(ni_agd_contrast)) ? (nint * ni_agd_contrast) : 0 )", ((primitive_value(has_offset) && primitive_value(ni_agd_contrast)) ? (nint * ni_agd_contrast) : 0 ));
            offset_agd_contrast = Eigen::Matrix<double, Eigen::Dynamic, 1>(((primitive_value(has_offset) && primitive_value(ni_agd_contrast)) ? (nint * ni_agd_contrast) : 0 ));
            stan::math::fill(offset_agd_contrast, DUMMY_VAR__);
            stan::math::assign(offset_agd_contrast,((primitive_value(has_offset) && primitive_value(ni_agd_contrast)) ? stan::math::promote_scalar<double>(stan::model::rvalue(offsets, stan::model::cons_list(stan::model::index_min_max(((ni_ipd + (nint * ni_agd_arm)) + 1), (ni_ipd + (nint * (ni_agd_arm + ni_agd_contrast)))), stan::model::nil_index_list()), "offsets")) : stan::math::promote_scalar<double>(odummy) ));
            current_statement_begin__ = 161;
            n_int_thin = int(0);
            stan::math::fill(n_int_thin, std::numeric_limits<int>::min());
            stan::math::assign(n_int_thin,(logical_gt(nint, 1) ? divide(nint, int_thin) : 0 ));
            current_statement_begin__ = 164;
            validate_non_negative_index("inv_Sigma", "(ni_agd_contrast ? ni_agd_contrast : 1 )", (ni_agd_contrast ? ni_agd_contrast : 1 ));
            validate_non_negative_index("inv_Sigma", "(ni_agd_contrast ? ni_agd_contrast : 1 )", (ni_agd_contrast ? ni_agd_contrast : 1 ));
            inv_Sigma = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((ni_agd_contrast ? ni_agd_contrast : 1 ), (ni_agd_contrast ? ni_agd_contrast : 1 ));
            stan::math::fill(inv_Sigma, DUMMY_VAR__);
            stan::math::assign(inv_Sigma,inverse_spd(agd_contrast_Sigma));
            current_statement_begin__ = 168;
            validate_non_negative_index("nc_agd_contrast", "ns_agd_contrast", ns_agd_contrast);
            nc_agd_contrast = std::vector<int>(ns_agd_contrast, int(0));
            stan::math::fill(nc_agd_contrast, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 169;
            if (as_bool(ns_agd_contrast)) {
                {
                current_statement_begin__ = 170;
                int s(0);
                (void) s;  // dummy to suppress unused var warning
                stan::math::fill(s, std::numeric_limits<int>::min());
                stan::math::assign(s,1);
                current_statement_begin__ = 171;
                int c(0);
                (void) c;  // dummy to suppress unused var warning
                stan::math::fill(c, std::numeric_limits<int>::min());
                stan::math::assign(c,1);
                current_statement_begin__ = 172;
                for (int i = 1; i <= (ni_agd_contrast - 1); ++i) {
                    current_statement_begin__ = 173;
                    if (as_bool(logical_eq(get_base1(agd_contrast_Sigma, i, (i + 1), "agd_contrast_Sigma", 1), 0))) {
                        current_statement_begin__ = 174;
                        stan::model::assign(nc_agd_contrast, 
                                    stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                    c, 
                                    "assigning variable nc_agd_contrast");
                        current_statement_begin__ = 175;
                        stan::math::assign(s, (s + 1));
                        current_statement_begin__ = 176;
                        stan::math::assign(c, 1);
                    } else {
                        current_statement_begin__ = 178;
                        stan::math::assign(c, (c + 1));
                    }
                }
                current_statement_begin__ = 182;
                stan::model::assign(nc_agd_contrast, 
                            stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                            c, 
                            "assigning variable nc_agd_contrast");
                }
            }
            // validate transformed data
            current_statement_begin__ = 121;
            check_greater_or_equal(function__, "n_delta", n_delta, 0);
            current_statement_begin__ = 126;
            stan::math::check_cholesky_factor_corr(function__, "RE_L", RE_L);
            current_statement_begin__ = 146;
            size_t trt_i_0_max__ = ((narm_ipd + ni_agd_arm) + ni_agd_contrast);
            for (size_t i_0__ = 0; i_0__ < trt_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "trt[i_0__]", trt[i_0__], 1);
            }
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 188;
            validate_non_negative_index("beta_tilde", "nX", nX);
            num_params_r__ += nX;
            current_statement_begin__ = 191;
            validate_non_negative_index("u_delta", "n_delta", n_delta);
            num_params_r__ += n_delta;
            current_statement_begin__ = 192;
            validate_non_negative_index("tau", "(RE ? 1 : 0 )", (RE ? 1 : 0 ));
            num_params_r__ += (RE ? 1 : 0 );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_binomial_2par() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 188;
        if (!(context__.contains_r("beta_tilde")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_tilde missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_tilde");
        pos__ = 0U;
        validate_non_negative_index("beta_tilde", "nX", nX);
        context__.validate_dims("parameter initialization", "beta_tilde", "vector_d", context__.to_vec(nX));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_tilde(nX);
        size_t beta_tilde_j_1_max__ = nX;
        for (size_t j_1__ = 0; j_1__ < beta_tilde_j_1_max__; ++j_1__) {
            beta_tilde(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_tilde);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_tilde: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 191;
        if (!(context__.contains_r("u_delta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable u_delta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("u_delta");
        pos__ = 0U;
        validate_non_negative_index("u_delta", "n_delta", n_delta);
        context__.validate_dims("parameter initialization", "u_delta", "vector_d", context__.to_vec(n_delta));
        Eigen::Matrix<double, Eigen::Dynamic, 1> u_delta(n_delta);
        size_t u_delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < u_delta_j_1_max__; ++j_1__) {
            u_delta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(u_delta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable u_delta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 192;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "(RE ? 1 : 0 )", (RE ? 1 : 0 ));
        context__.validate_dims("parameter initialization", "tau", "vector_d", context__.to_vec((RE ? 1 : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau((RE ? 1 : 0 ));
        size_t tau_j_1_max__ = (RE ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            tau(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, tau);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 188;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_tilde;
            (void) beta_tilde;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_tilde = in__.vector_constrain(nX, lp__);
            else
                beta_tilde = in__.vector_constrain(nX);
            current_statement_begin__ = 191;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> u_delta;
            (void) u_delta;  // dummy to suppress unused var warning
            if (jacobian__)
                u_delta = in__.vector_constrain(n_delta, lp__);
            else
                u_delta = in__.vector_constrain(n_delta);
            current_statement_begin__ = 192;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau;
            (void) tau;  // dummy to suppress unused var warning
            if (jacobian__)
                tau = in__.vector_lb_constrain(0, (RE ? 1 : 0 ), lp__);
            else
                tau = in__.vector_lb_constrain(0, (RE ? 1 : 0 ));
            // transformed parameters
            current_statement_begin__ = 195;
            validate_non_negative_index("theta2_agd_arm_bar", "ni_agd_arm", ni_agd_arm);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta2_agd_arm_bar(ni_agd_arm);
            stan::math::initialize(theta2_agd_arm_bar, DUMMY_VAR__);
            stan::math::fill(theta2_agd_arm_bar, DUMMY_VAR__);
            current_statement_begin__ = 196;
            validate_non_negative_index("nprime", "ni_agd_arm", ni_agd_arm);
            std::vector<local_scalar_t__> nprime(ni_agd_arm, local_scalar_t__(0));
            stan::math::initialize(nprime, DUMMY_VAR__);
            stan::math::fill(nprime, DUMMY_VAR__);
            current_statement_begin__ = 197;
            validate_non_negative_index("pprime", "ni_agd_arm", ni_agd_arm);
            std::vector<local_scalar_t__> pprime(ni_agd_arm, local_scalar_t__(0));
            stan::math::initialize(pprime, DUMMY_VAR__);
            stan::math::fill(pprime, DUMMY_VAR__);
            current_statement_begin__ = 200;
            validate_non_negative_index("theta_ipd", "ni_ipd", ni_ipd);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_ipd(ni_ipd);
            stan::math::initialize(theta_ipd, DUMMY_VAR__);
            stan::math::fill(theta_ipd, DUMMY_VAR__);
            current_statement_begin__ = 201;
            validate_non_negative_index("theta_agd_arm_ii", "(logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 )", (logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_agd_arm_ii((logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 ));
            stan::math::initialize(theta_agd_arm_ii, DUMMY_VAR__);
            stan::math::fill(theta_agd_arm_ii, DUMMY_VAR__);
            current_statement_begin__ = 202;
            validate_non_negative_index("theta_agd_arm_bar", "ni_agd_arm", ni_agd_arm);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> theta_agd_arm_bar(ni_agd_arm);
            stan::math::initialize(theta_agd_arm_bar, DUMMY_VAR__);
            stan::math::fill(theta_agd_arm_bar, DUMMY_VAR__);
            current_statement_begin__ = 206;
            validate_non_negative_index("eta_ipd", "ni_ipd", ni_ipd);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_ipd(ni_ipd);
            stan::math::initialize(eta_ipd, DUMMY_VAR__);
            stan::math::fill(eta_ipd, DUMMY_VAR__);
            current_statement_begin__ = 211;
            validate_non_negative_index("f_delta", "n_delta", n_delta);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> f_delta(n_delta);
            stan::math::initialize(f_delta, DUMMY_VAR__);
            stan::math::fill(f_delta, DUMMY_VAR__);
            stan::math::assign(f_delta,(RE ? stan::math::promote_scalar<local_scalar_t__>((RE_sparse ? stan::math::promote_scalar<local_scalar_t__>(multiply(get_base1(tau, 1, "tau", 1), csr_matrix_times_vector(n_delta, n_delta, RE_L_w, RE_L_v, RE_L_u, u_delta))) : stan::math::promote_scalar<local_scalar_t__>(multiply(multiply(get_base1(tau, 1, "tau", 1), RE_L), u_delta)) )) : stan::math::promote_scalar<local_scalar_t__>(u_delta) ));
            current_statement_begin__ = 219;
            validate_non_negative_index("allbeta", "nX", nX);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> allbeta(nX);
            stan::math::initialize(allbeta, DUMMY_VAR__);
            stan::math::fill(allbeta, DUMMY_VAR__);
            stan::math::assign(allbeta,(QR ? stan::math::promote_scalar<local_scalar_t__>(multiply(R_inv, beta_tilde)) : stan::math::promote_scalar<local_scalar_t__>(beta_tilde) ));
            current_statement_begin__ = 221;
            validate_non_negative_index("mu", "totns", totns);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> mu(totns);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 223;
            validate_non_negative_index("d", "(nt - 1)", (nt - 1));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> d((nt - 1));
            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d, DUMMY_VAR__);
            stan::math::assign(d,stan::model::rvalue(allbeta, stan::model::cons_list(stan::model::index_min_max((totns + 1), ((totns + nt) - 1)), stan::model::nil_index_list()), "allbeta"));
            current_statement_begin__ = 225;
            validate_non_negative_index("omega", "nodesplit", nodesplit);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> omega(nodesplit);
            stan::math::initialize(omega, DUMMY_VAR__);
            stan::math::fill(omega, DUMMY_VAR__);
            current_statement_begin__ = 227;
            validate_non_negative_index("beta", "(((nX - totns) - (nt - 1)) - nodesplit)", (((nX - totns) - (nt - 1)) - nodesplit));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta((((nX - totns) - (nt - 1)) - nodesplit));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 232;
            validate_non_negative_index("eta_agd_contrast_ii", "(logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 )", (logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_contrast_ii((logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 ));
            stan::math::initialize(eta_agd_contrast_ii, DUMMY_VAR__);
            stan::math::fill(eta_agd_contrast_ii, DUMMY_VAR__);
            current_statement_begin__ = 233;
            validate_non_negative_index("eta_agd_contrast_bar", "ni_agd_contrast", ni_agd_contrast);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_contrast_bar(ni_agd_contrast);
            stan::math::initialize(eta_agd_contrast_bar, DUMMY_VAR__);
            stan::math::fill(eta_agd_contrast_bar, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 237;
            if (as_bool(totns)) {
                current_statement_begin__ = 238;
                stan::math::assign(mu, stan::model::rvalue(allbeta, stan::model::cons_list(stan::model::index_min_max(1, totns), stan::model::nil_index_list()), "allbeta"));
            }
            current_statement_begin__ = 243;
            if (as_bool((((nX - totns) - (nt - 1)) - nodesplit))) {
                current_statement_begin__ = 244;
                stan::math::assign(beta, stan::model::rvalue(allbeta, stan::model::cons_list(stan::model::index_min(((totns + nt) + nodesplit)), stan::model::nil_index_list()), "allbeta"));
            }
            current_statement_begin__ = 249;
            if (as_bool(nodesplit)) {
                current_statement_begin__ = 250;
                stan::model::assign(omega, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(allbeta, (totns + nt), "allbeta", 1), 
                            "assigning variable omega");
            }
            current_statement_begin__ = 258;
            if (as_bool(ni_ipd)) {
                current_statement_begin__ = 259;
                if (as_bool(RE)) {
                    {
                    current_statement_begin__ = 261;
                    validate_non_negative_index("eta_ipd_noRE", "ni_ipd", ni_ipd);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_ipd_noRE(ni_ipd);
                    stan::math::initialize(eta_ipd_noRE, DUMMY_VAR__);
                    stan::math::fill(eta_ipd_noRE, DUMMY_VAR__);
                    stan::math::assign(eta_ipd_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_ipd, beta_tilde), offset_ipd)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_ipd, beta_tilde)) ));
                    current_statement_begin__ = 265;
                    for (int i = 1; i <= ni_ipd; ++i) {
                        current_statement_begin__ = 266;
                        if (as_bool(get_base1(which_RE, get_base1(ipd_arm, i, "ipd_arm", 1), "which_RE", 1))) {
                            current_statement_begin__ = 267;
                            stan::model::assign(eta_ipd, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(eta_ipd_noRE, i, "eta_ipd_noRE", 1) + get_base1(f_delta, get_base1(which_RE, get_base1(ipd_arm, i, "ipd_arm", 1), "which_RE", 1), "f_delta", 1)), 
                                        "assigning variable eta_ipd");
                        } else {
                            current_statement_begin__ = 269;
                            stan::model::assign(eta_ipd, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(eta_ipd_noRE, i, "eta_ipd_noRE", 1), 
                                        "assigning variable eta_ipd");
                        }
                    }
                    }
                } else {
                    current_statement_begin__ = 273;
                    stan::math::assign(eta_ipd, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_ipd, beta_tilde), offset_ipd)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_ipd, beta_tilde)) ));
                }
            }
            current_statement_begin__ = 280;
            if (as_bool(ni_agd_contrast)) {
                current_statement_begin__ = 281;
                if (as_bool(logical_gt(nint, 1))) {
                    current_statement_begin__ = 282;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 283;
                        validate_non_negative_index("eta_agd_contrast_noRE", "(nint * ni_agd_contrast)", (nint * ni_agd_contrast));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_contrast_noRE((nint * ni_agd_contrast));
                        stan::math::initialize(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_contrast_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                        current_statement_begin__ = 287;
                        for (int i = 1; i <= ni_agd_contrast; ++i) {
                            current_statement_begin__ = 288;
                            if (as_bool(get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1))) {
                                current_statement_begin__ = 289;
                                stan::model::assign(eta_agd_contrast_ii, 
                                            stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                            add(stan::model::rvalue(eta_agd_contrast_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_noRE"), get_base1(f_delta, get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1), "f_delta", 1)), 
                                            "assigning variable eta_agd_contrast_ii");
                            } else {
                                current_statement_begin__ = 292;
                                stan::model::assign(eta_agd_contrast_ii, 
                                            stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                            stan::model::rvalue(eta_agd_contrast_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_noRE"), 
                                            "assigning variable eta_agd_contrast_ii");
                            }
                            current_statement_begin__ = 295;
                            stan::model::assign(eta_agd_contrast_bar, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        mean(stan::model::rvalue(eta_agd_contrast_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_ii")), 
                                        "assigning variable eta_agd_contrast_bar");
                        }
                        }
                    } else {
                        current_statement_begin__ = 298;
                        stan::math::assign(eta_agd_contrast_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                        current_statement_begin__ = 302;
                        for (int i = 1; i <= ni_agd_contrast; ++i) {
                            current_statement_begin__ = 303;
                            stan::model::assign(eta_agd_contrast_bar, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        mean(stan::model::rvalue(eta_agd_contrast_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_ii")), 
                                        "assigning variable eta_agd_contrast_bar");
                        }
                    }
                } else {
                    current_statement_begin__ = 307;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 308;
                        validate_non_negative_index("eta_agd_contrast_noRE", "(nint * ni_agd_contrast)", (nint * ni_agd_contrast));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_contrast_noRE((nint * ni_agd_contrast));
                        stan::math::initialize(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_contrast_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                        current_statement_begin__ = 312;
                        for (int i = 1; i <= ni_agd_contrast; ++i) {
                            current_statement_begin__ = 313;
                            if (as_bool(get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1))) {
                                current_statement_begin__ = 314;
                                stan::model::assign(eta_agd_contrast_bar, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            (get_base1(eta_agd_contrast_noRE, i, "eta_agd_contrast_noRE", 1) + get_base1(f_delta, get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1), "f_delta", 1)), 
                                            "assigning variable eta_agd_contrast_bar");
                            } else {
                                current_statement_begin__ = 316;
                                stan::model::assign(eta_agd_contrast_bar, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            get_base1(eta_agd_contrast_noRE, i, "eta_agd_contrast_noRE", 1), 
                                            "assigning variable eta_agd_contrast_bar");
                            }
                        }
                        }
                    } else {
                        current_statement_begin__ = 319;
                        stan::math::assign(eta_agd_contrast_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                    }
                }
            }
            current_statement_begin__ = 327;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 328;
                stan::math::assign(theta_ipd, inv_logit(eta_ipd));
            } else if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 330;
                stan::math::assign(theta_ipd, Phi(eta_ipd));
            } else if (as_bool(logical_eq(link, 3))) {
                current_statement_begin__ = 332;
                stan::math::assign(theta_ipd, inv_cloglog(eta_ipd));
            }
            current_statement_begin__ = 335;
            if (as_bool(ni_agd_arm)) {
                current_statement_begin__ = 336;
                if (as_bool(logical_gt(nint, 1))) {
                    current_statement_begin__ = 337;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 338;
                        validate_non_negative_index("eta_agd_arm_noRE", "(nint * ni_agd_arm)", (nint * ni_agd_arm));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_arm_noRE((nint * ni_agd_arm));
                        stan::math::initialize(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_arm_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_arm, beta_tilde)) ));
                        current_statement_begin__ = 342;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 343;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 344;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 345;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_logit(add(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE"), get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_ii");
                                } else {
                                    current_statement_begin__ = 347;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_logit(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE")), 
                                                "assigning variable theta_agd_arm_ii");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 350;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 351;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 352;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                Phi(add(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE"), get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_ii");
                                } else {
                                    current_statement_begin__ = 354;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                Phi(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE")), 
                                                "assigning variable theta_agd_arm_ii");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 357;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 358;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 359;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_cloglog(add(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE"), get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_ii");
                                } else {
                                    current_statement_begin__ = 361;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_cloglog(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE")), 
                                                "assigning variable theta_agd_arm_ii");
                                }
                            }
                        }
                        }
                    } else {
                        current_statement_begin__ = 365;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 366;
                            stan::math::assign(theta_agd_arm_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_logit(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_logit(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 370;
                            stan::math::assign(theta_agd_arm_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(Phi(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(Phi(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 374;
                            stan::math::assign(theta_agd_arm_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(multiply(X_agd_arm, beta_tilde))) ));
                        }
                    }
                    current_statement_begin__ = 380;
                    for (int i = 1; i <= ni_agd_arm; ++i) {
                        current_statement_begin__ = 381;
                        stan::model::assign(theta_agd_arm_bar, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    mean(stan::model::rvalue(theta_agd_arm_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "theta_agd_arm_ii")), 
                                    "assigning variable theta_agd_arm_bar");
                        current_statement_begin__ = 382;
                        stan::model::assign(theta2_agd_arm_bar, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (dot_self(stan::model::rvalue(theta_agd_arm_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "theta_agd_arm_ii")) / nint), 
                                    "assigning variable theta2_agd_arm_bar");
                        current_statement_begin__ = 385;
                        stan::model::assign(nprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(agd_arm_n, i, "agd_arm_n", 1) * pow(get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1), 2)) / get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1)), 
                                    "assigning variable nprime");
                        current_statement_begin__ = 386;
                        stan::model::assign(pprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1) / get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1)), 
                                    "assigning variable pprime");
                        current_statement_begin__ = 389;
                        if (as_bool(logical_lt(get_base1(nprime, i, "nprime", 1), get_base1(agd_arm_r, i, "agd_arm_r", 1)))) {
                            current_statement_begin__ = 389;
                            std::stringstream errmsg_stream__;
                            errmsg_stream__ << "nprime = ";
                            errmsg_stream__ << get_base1(nprime, i, "nprime", 1);
                            errmsg_stream__ << " less than r = ";
                            errmsg_stream__ << get_base1(agd_arm_r, i, "agd_arm_r", 1);
                            throw std::domain_error(errmsg_stream__.str());
                        }
                    }
                } else {
                    current_statement_begin__ = 392;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 393;
                        validate_non_negative_index("eta_agd_arm_noRE", "(nint * ni_agd_arm)", (nint * ni_agd_arm));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_arm_noRE((nint * ni_agd_arm));
                        stan::math::initialize(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_arm_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_arm, beta_tilde)) ));
                        current_statement_begin__ = 397;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 398;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 399;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 400;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_logit((get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1) + get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_bar");
                                } else {
                                    current_statement_begin__ = 402;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_logit(get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1)), 
                                                "assigning variable theta_agd_arm_bar");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 405;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 406;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 407;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                Phi((get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1) + get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_bar");
                                } else {
                                    current_statement_begin__ = 409;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                Phi(get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1)), 
                                                "assigning variable theta_agd_arm_bar");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 412;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 413;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 414;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_cloglog((get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1) + get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_bar");
                                } else {
                                    current_statement_begin__ = 416;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_cloglog(get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1)), 
                                                "assigning variable theta_agd_arm_bar");
                                }
                            }
                        }
                        }
                    } else {
                        current_statement_begin__ = 420;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 421;
                            stan::math::assign(theta_agd_arm_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_logit(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_logit(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 425;
                            stan::math::assign(theta_agd_arm_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(Phi(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(Phi(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 429;
                            stan::math::assign(theta_agd_arm_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(multiply(X_agd_arm, beta_tilde))) ));
                        }
                    }
                    current_statement_begin__ = 434;
                    stan::math::assign(theta2_agd_arm_bar, elt_multiply(theta_agd_arm_bar, theta_agd_arm_bar));
                    current_statement_begin__ = 436;
                    for (int i = 1; i <= ni_agd_arm; ++i) {
                        current_statement_begin__ = 438;
                        stan::model::assign(nprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(agd_arm_n, i, "agd_arm_n", 1) * pow(get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1), 2)) / get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1)), 
                                    "assigning variable nprime");
                        current_statement_begin__ = 439;
                        stan::model::assign(pprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1) / get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1)), 
                                    "assigning variable pprime");
                        current_statement_begin__ = 442;
                        if (as_bool(logical_lt(get_base1(nprime, i, "nprime", 1), get_base1(agd_arm_r, i, "agd_arm_r", 1)))) {
                            current_statement_begin__ = 442;
                            std::stringstream errmsg_stream__;
                            errmsg_stream__ << "nprime = ";
                            errmsg_stream__ << get_base1(nprime, i, "nprime", 1);
                            errmsg_stream__ << " less than r = ";
                            errmsg_stream__ << get_base1(agd_arm_r, i, "agd_arm_r", 1);
                            throw std::domain_error(errmsg_stream__.str());
                        }
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 195;
            size_t theta2_agd_arm_bar_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < theta2_agd_arm_bar_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta2_agd_arm_bar(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta2_agd_arm_bar" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta2_agd_arm_bar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 196;
            size_t nprime_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < nprime_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(nprime[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: nprime" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable nprime: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t nprime_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < nprime_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nprime[i_0__]", nprime[i_0__], 0);
            }
            current_statement_begin__ = 197;
            size_t pprime_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < pprime_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(pprime[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: pprime" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable pprime: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t pprime_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < pprime_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pprime[i_0__]", pprime[i_0__], 0);
                check_less_or_equal(function__, "pprime[i_0__]", pprime[i_0__], 1);
            }
            current_statement_begin__ = 200;
            size_t theta_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < theta_ipd_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_ipd(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_ipd" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_ipd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 201;
            size_t theta_agd_arm_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_agd_arm_ii_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_agd_arm_ii(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_agd_arm_ii" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_agd_arm_ii: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 202;
            size_t theta_agd_arm_bar_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < theta_agd_arm_bar_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(theta_agd_arm_bar(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta_agd_arm_bar" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_agd_arm_bar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 206;
            size_t eta_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < eta_ipd_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta_ipd(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta_ipd" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_ipd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 211;
            size_t f_delta_j_1_max__ = n_delta;
            for (size_t j_1__ = 0; j_1__ < f_delta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(f_delta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: f_delta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable f_delta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 219;
            size_t allbeta_j_1_max__ = nX;
            for (size_t j_1__ = 0; j_1__ < allbeta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(allbeta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: allbeta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable allbeta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 221;
            size_t mu_j_1_max__ = totns;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(mu(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mu" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 223;
            size_t d_j_1_max__ = (nt - 1);
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(d(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: d" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable d: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 225;
            size_t omega_j_1_max__ = nodesplit;
            for (size_t j_1__ = 0; j_1__ < omega_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(omega(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: omega" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable omega: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 227;
            size_t beta_j_1_max__ = (((nX - totns) - (nt - 1)) - nodesplit);
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(beta(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 232;
            size_t eta_agd_contrast_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 );
            for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_ii_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta_agd_contrast_ii(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta_agd_contrast_ii" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_agd_contrast_ii: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 233;
            size_t eta_agd_contrast_bar_j_1_max__ = ni_agd_contrast;
            for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_bar_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(eta_agd_contrast_bar(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: eta_agd_contrast_bar" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable eta_agd_contrast_bar: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 452;
            prior_select_lp(mu, prior_intercept_dist, prior_intercept_location, prior_intercept_scale, prior_intercept_df, lp__, lp_accum__, pstream__);
            current_statement_begin__ = 454;
            prior_select_lp(d, prior_trt_dist, prior_trt_location, prior_trt_scale, prior_trt_df, lp__, lp_accum__, pstream__);
            current_statement_begin__ = 456;
            prior_select_lp(beta, prior_reg_dist, prior_reg_location, prior_reg_scale, prior_reg_df, lp__, lp_accum__, pstream__);
            current_statement_begin__ = 459;
            prior_select_lp(omega, prior_trt_dist, prior_trt_location, prior_trt_scale, prior_trt_df, lp__, lp_accum__, pstream__);
            current_statement_begin__ = 462;
            if (as_bool(RE)) {
                current_statement_begin__ = 463;
                if (as_bool(logical_eq(prior_het_type, 1))) {
                    current_statement_begin__ = 464;
                    prior_select_lp(tau, prior_het_dist, prior_het_location, prior_het_scale, prior_het_df, lp__, lp_accum__, pstream__);
                } else {
                    {
                    current_statement_begin__ = 468;
                    validate_non_negative_index("tau_t", "(RE ? 1 : 0 )", (RE ? 1 : 0 ));
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tau_t((RE ? 1 : 0 ));
                    stan::math::initialize(tau_t, DUMMY_VAR__);
                    stan::math::fill(tau_t, DUMMY_VAR__);
                    current_statement_begin__ = 470;
                    if (as_bool(logical_eq(prior_het_type, 2))) {
                        current_statement_begin__ = 471;
                        stan::model::assign(tau_t, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    pow(get_base1(tau, 1, "tau", 1), 2), 
                                    "assigning variable tau_t");
                        current_statement_begin__ = 472;
                        lp_accum__.add(stan::math::log(tau));
                    } else if (as_bool(logical_eq(prior_het_type, 3))) {
                        current_statement_begin__ = 475;
                        stan::model::assign(tau_t, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                                    pow(get_base1(tau, 1, "tau", 1), -(2)), 
                                    "assigning variable tau_t");
                        current_statement_begin__ = 476;
                        lp_accum__.add(multiply(-(3), stan::math::log(tau)));
                    }
                    current_statement_begin__ = 478;
                    prior_select_lp(tau_t, prior_het_dist, prior_het_location, prior_het_scale, prior_het_df, lp__, lp_accum__, pstream__);
                    }
                }
            }
            current_statement_begin__ = 483;
            lp_accum__.add(std_normal_log<propto__>(u_delta));
            current_statement_begin__ = 486;
            if (as_bool(ni_agd_contrast)) {
                current_statement_begin__ = 487;
                lp_accum__.add(multi_normal_log<propto__>(agd_contrast_y, eta_agd_contrast_bar, agd_contrast_Sigma));
            }
            current_statement_begin__ = 491;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 493;
                lp_accum__.add(bernoulli_logit_log<propto__>(ipd_r, eta_ipd));
            } else {
                current_statement_begin__ = 495;
                lp_accum__.add(bernoulli_log<propto__>(ipd_r, theta_ipd));
            }
            current_statement_begin__ = 503;
            for (int i = 1; i <= ni_agd_arm; ++i) {
                current_statement_begin__ = 504;
                lp_accum__.add(((binomial_coefficient_log(get_base1(nprime, i, "nprime", 1), get_base1(agd_arm_r, i, "agd_arm_r", 1)) + multiply_log(get_base1(agd_arm_r, i, "agd_arm_r", 1), get_base1(pprime, i, "pprime", 1))) + ((get_base1(nprime, i, "nprime", 1) - get_base1(agd_arm_r, i, "agd_arm_r", 1)) * log1m(get_base1(pprime, i, "pprime", 1)))));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta_tilde");
        names__.push_back("u_delta");
        names__.push_back("tau");
        names__.push_back("theta2_agd_arm_bar");
        names__.push_back("nprime");
        names__.push_back("pprime");
        names__.push_back("theta_ipd");
        names__.push_back("theta_agd_arm_ii");
        names__.push_back("theta_agd_arm_bar");
        names__.push_back("eta_ipd");
        names__.push_back("f_delta");
        names__.push_back("allbeta");
        names__.push_back("mu");
        names__.push_back("d");
        names__.push_back("omega");
        names__.push_back("beta");
        names__.push_back("eta_agd_contrast_ii");
        names__.push_back("eta_agd_contrast_bar");
        names__.push_back("theta2_bar_cum");
        names__.push_back("fitted_ipd");
        names__.push_back("fitted_agd_arm");
        names__.push_back("theta_bar_cum_agd_arm");
        names__.push_back("log_lik");
        names__.push_back("resdev");
        names__.push_back("fitted_agd_contrast");
        names__.push_back("theta_bar_cum_agd_contrast");
        names__.push_back("delta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_delta);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((RE ? 1 : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_arm);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_arm);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_arm);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_ipd);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_arm);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_ipd);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_delta);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nX);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(totns);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nt - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nodesplit);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((((nX - totns) - (nt - 1)) - nodesplit));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_contrast);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ni_agd_arm * n_int_thin));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_ipd);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_arm);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ni_agd_arm * n_int_thin));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((ni_ipd + ni_agd_arm) + ns_agd_contrast));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((ni_ipd + ni_agd_arm) + ns_agd_contrast));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ni_agd_contrast);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((ni_agd_contrast * n_int_thin));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_delta);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_binomial_2par_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_tilde = in__.vector_constrain(nX);
        size_t beta_tilde_j_1_max__ = nX;
        for (size_t j_1__ = 0; j_1__ < beta_tilde_j_1_max__; ++j_1__) {
            vars__.push_back(beta_tilde(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> u_delta = in__.vector_constrain(n_delta);
        size_t u_delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < u_delta_j_1_max__; ++j_1__) {
            vars__.push_back(u_delta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> tau = in__.vector_lb_constrain(0, (RE ? 1 : 0 ));
        size_t tau_j_1_max__ = (RE ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            vars__.push_back(tau(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 195;
            validate_non_negative_index("theta2_agd_arm_bar", "ni_agd_arm", ni_agd_arm);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta2_agd_arm_bar(ni_agd_arm);
            stan::math::initialize(theta2_agd_arm_bar, DUMMY_VAR__);
            stan::math::fill(theta2_agd_arm_bar, DUMMY_VAR__);
            current_statement_begin__ = 196;
            validate_non_negative_index("nprime", "ni_agd_arm", ni_agd_arm);
            std::vector<double> nprime(ni_agd_arm, double(0));
            stan::math::initialize(nprime, DUMMY_VAR__);
            stan::math::fill(nprime, DUMMY_VAR__);
            current_statement_begin__ = 197;
            validate_non_negative_index("pprime", "ni_agd_arm", ni_agd_arm);
            std::vector<double> pprime(ni_agd_arm, double(0));
            stan::math::initialize(pprime, DUMMY_VAR__);
            stan::math::fill(pprime, DUMMY_VAR__);
            current_statement_begin__ = 200;
            validate_non_negative_index("theta_ipd", "ni_ipd", ni_ipd);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_ipd(ni_ipd);
            stan::math::initialize(theta_ipd, DUMMY_VAR__);
            stan::math::fill(theta_ipd, DUMMY_VAR__);
            current_statement_begin__ = 201;
            validate_non_negative_index("theta_agd_arm_ii", "(logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 )", (logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_agd_arm_ii((logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 ));
            stan::math::initialize(theta_agd_arm_ii, DUMMY_VAR__);
            stan::math::fill(theta_agd_arm_ii, DUMMY_VAR__);
            current_statement_begin__ = 202;
            validate_non_negative_index("theta_agd_arm_bar", "ni_agd_arm", ni_agd_arm);
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_agd_arm_bar(ni_agd_arm);
            stan::math::initialize(theta_agd_arm_bar, DUMMY_VAR__);
            stan::math::fill(theta_agd_arm_bar, DUMMY_VAR__);
            current_statement_begin__ = 206;
            validate_non_negative_index("eta_ipd", "ni_ipd", ni_ipd);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta_ipd(ni_ipd);
            stan::math::initialize(eta_ipd, DUMMY_VAR__);
            stan::math::fill(eta_ipd, DUMMY_VAR__);
            current_statement_begin__ = 211;
            validate_non_negative_index("f_delta", "n_delta", n_delta);
            Eigen::Matrix<double, Eigen::Dynamic, 1> f_delta(n_delta);
            stan::math::initialize(f_delta, DUMMY_VAR__);
            stan::math::fill(f_delta, DUMMY_VAR__);
            stan::math::assign(f_delta,(RE ? stan::math::promote_scalar<local_scalar_t__>((RE_sparse ? stan::math::promote_scalar<local_scalar_t__>(multiply(get_base1(tau, 1, "tau", 1), csr_matrix_times_vector(n_delta, n_delta, RE_L_w, RE_L_v, RE_L_u, u_delta))) : stan::math::promote_scalar<local_scalar_t__>(multiply(multiply(get_base1(tau, 1, "tau", 1), RE_L), u_delta)) )) : stan::math::promote_scalar<local_scalar_t__>(u_delta) ));
            current_statement_begin__ = 219;
            validate_non_negative_index("allbeta", "nX", nX);
            Eigen::Matrix<double, Eigen::Dynamic, 1> allbeta(nX);
            stan::math::initialize(allbeta, DUMMY_VAR__);
            stan::math::fill(allbeta, DUMMY_VAR__);
            stan::math::assign(allbeta,(QR ? stan::math::promote_scalar<local_scalar_t__>(multiply(R_inv, beta_tilde)) : stan::math::promote_scalar<local_scalar_t__>(beta_tilde) ));
            current_statement_begin__ = 221;
            validate_non_negative_index("mu", "totns", totns);
            Eigen::Matrix<double, Eigen::Dynamic, 1> mu(totns);
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 223;
            validate_non_negative_index("d", "(nt - 1)", (nt - 1));
            Eigen::Matrix<double, Eigen::Dynamic, 1> d((nt - 1));
            stan::math::initialize(d, DUMMY_VAR__);
            stan::math::fill(d, DUMMY_VAR__);
            stan::math::assign(d,stan::model::rvalue(allbeta, stan::model::cons_list(stan::model::index_min_max((totns + 1), ((totns + nt) - 1)), stan::model::nil_index_list()), "allbeta"));
            current_statement_begin__ = 225;
            validate_non_negative_index("omega", "nodesplit", nodesplit);
            Eigen::Matrix<double, Eigen::Dynamic, 1> omega(nodesplit);
            stan::math::initialize(omega, DUMMY_VAR__);
            stan::math::fill(omega, DUMMY_VAR__);
            current_statement_begin__ = 227;
            validate_non_negative_index("beta", "(((nX - totns) - (nt - 1)) - nodesplit)", (((nX - totns) - (nt - 1)) - nodesplit));
            Eigen::Matrix<double, Eigen::Dynamic, 1> beta((((nX - totns) - (nt - 1)) - nodesplit));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 232;
            validate_non_negative_index("eta_agd_contrast_ii", "(logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 )", (logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta_agd_contrast_ii((logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 ));
            stan::math::initialize(eta_agd_contrast_ii, DUMMY_VAR__);
            stan::math::fill(eta_agd_contrast_ii, DUMMY_VAR__);
            current_statement_begin__ = 233;
            validate_non_negative_index("eta_agd_contrast_bar", "ni_agd_contrast", ni_agd_contrast);
            Eigen::Matrix<double, Eigen::Dynamic, 1> eta_agd_contrast_bar(ni_agd_contrast);
            stan::math::initialize(eta_agd_contrast_bar, DUMMY_VAR__);
            stan::math::fill(eta_agd_contrast_bar, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 237;
            if (as_bool(totns)) {
                current_statement_begin__ = 238;
                stan::math::assign(mu, stan::model::rvalue(allbeta, stan::model::cons_list(stan::model::index_min_max(1, totns), stan::model::nil_index_list()), "allbeta"));
            }
            current_statement_begin__ = 243;
            if (as_bool((((nX - totns) - (nt - 1)) - nodesplit))) {
                current_statement_begin__ = 244;
                stan::math::assign(beta, stan::model::rvalue(allbeta, stan::model::cons_list(stan::model::index_min(((totns + nt) + nodesplit)), stan::model::nil_index_list()), "allbeta"));
            }
            current_statement_begin__ = 249;
            if (as_bool(nodesplit)) {
                current_statement_begin__ = 250;
                stan::model::assign(omega, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            get_base1(allbeta, (totns + nt), "allbeta", 1), 
                            "assigning variable omega");
            }
            current_statement_begin__ = 258;
            if (as_bool(ni_ipd)) {
                current_statement_begin__ = 259;
                if (as_bool(RE)) {
                    {
                    current_statement_begin__ = 261;
                    validate_non_negative_index("eta_ipd_noRE", "ni_ipd", ni_ipd);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_ipd_noRE(ni_ipd);
                    stan::math::initialize(eta_ipd_noRE, DUMMY_VAR__);
                    stan::math::fill(eta_ipd_noRE, DUMMY_VAR__);
                    stan::math::assign(eta_ipd_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_ipd, beta_tilde), offset_ipd)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_ipd, beta_tilde)) ));
                    current_statement_begin__ = 265;
                    for (int i = 1; i <= ni_ipd; ++i) {
                        current_statement_begin__ = 266;
                        if (as_bool(get_base1(which_RE, get_base1(ipd_arm, i, "ipd_arm", 1), "which_RE", 1))) {
                            current_statement_begin__ = 267;
                            stan::model::assign(eta_ipd, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        (get_base1(eta_ipd_noRE, i, "eta_ipd_noRE", 1) + get_base1(f_delta, get_base1(which_RE, get_base1(ipd_arm, i, "ipd_arm", 1), "which_RE", 1), "f_delta", 1)), 
                                        "assigning variable eta_ipd");
                        } else {
                            current_statement_begin__ = 269;
                            stan::model::assign(eta_ipd, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        get_base1(eta_ipd_noRE, i, "eta_ipd_noRE", 1), 
                                        "assigning variable eta_ipd");
                        }
                    }
                    }
                } else {
                    current_statement_begin__ = 273;
                    stan::math::assign(eta_ipd, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_ipd, beta_tilde), offset_ipd)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_ipd, beta_tilde)) ));
                }
            }
            current_statement_begin__ = 280;
            if (as_bool(ni_agd_contrast)) {
                current_statement_begin__ = 281;
                if (as_bool(logical_gt(nint, 1))) {
                    current_statement_begin__ = 282;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 283;
                        validate_non_negative_index("eta_agd_contrast_noRE", "(nint * ni_agd_contrast)", (nint * ni_agd_contrast));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_contrast_noRE((nint * ni_agd_contrast));
                        stan::math::initialize(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_contrast_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                        current_statement_begin__ = 287;
                        for (int i = 1; i <= ni_agd_contrast; ++i) {
                            current_statement_begin__ = 288;
                            if (as_bool(get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1))) {
                                current_statement_begin__ = 289;
                                stan::model::assign(eta_agd_contrast_ii, 
                                            stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                            add(stan::model::rvalue(eta_agd_contrast_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_noRE"), get_base1(f_delta, get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1), "f_delta", 1)), 
                                            "assigning variable eta_agd_contrast_ii");
                            } else {
                                current_statement_begin__ = 292;
                                stan::model::assign(eta_agd_contrast_ii, 
                                            stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                            stan::model::rvalue(eta_agd_contrast_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_noRE"), 
                                            "assigning variable eta_agd_contrast_ii");
                            }
                            current_statement_begin__ = 295;
                            stan::model::assign(eta_agd_contrast_bar, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        mean(stan::model::rvalue(eta_agd_contrast_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_ii")), 
                                        "assigning variable eta_agd_contrast_bar");
                        }
                        }
                    } else {
                        current_statement_begin__ = 298;
                        stan::math::assign(eta_agd_contrast_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                        current_statement_begin__ = 302;
                        for (int i = 1; i <= ni_agd_contrast; ++i) {
                            current_statement_begin__ = 303;
                            stan::model::assign(eta_agd_contrast_bar, 
                                        stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                        mean(stan::model::rvalue(eta_agd_contrast_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_contrast_ii")), 
                                        "assigning variable eta_agd_contrast_bar");
                        }
                    }
                } else {
                    current_statement_begin__ = 307;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 308;
                        validate_non_negative_index("eta_agd_contrast_noRE", "(nint * ni_agd_contrast)", (nint * ni_agd_contrast));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_contrast_noRE((nint * ni_agd_contrast));
                        stan::math::initialize(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_contrast_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_contrast_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                        current_statement_begin__ = 312;
                        for (int i = 1; i <= ni_agd_contrast; ++i) {
                            current_statement_begin__ = 313;
                            if (as_bool(get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1))) {
                                current_statement_begin__ = 314;
                                stan::model::assign(eta_agd_contrast_bar, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            (get_base1(eta_agd_contrast_noRE, i, "eta_agd_contrast_noRE", 1) + get_base1(f_delta, get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1), "f_delta", 1)), 
                                            "assigning variable eta_agd_contrast_bar");
                            } else {
                                current_statement_begin__ = 316;
                                stan::model::assign(eta_agd_contrast_bar, 
                                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                            get_base1(eta_agd_contrast_noRE, i, "eta_agd_contrast_noRE", 1), 
                                            "assigning variable eta_agd_contrast_bar");
                            }
                        }
                        }
                    } else {
                        current_statement_begin__ = 319;
                        stan::math::assign(eta_agd_contrast_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_contrast, beta_tilde), offset_agd_contrast)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_contrast, beta_tilde)) ));
                    }
                }
            }
            current_statement_begin__ = 327;
            if (as_bool(logical_eq(link, 1))) {
                current_statement_begin__ = 328;
                stan::math::assign(theta_ipd, inv_logit(eta_ipd));
            } else if (as_bool(logical_eq(link, 2))) {
                current_statement_begin__ = 330;
                stan::math::assign(theta_ipd, Phi(eta_ipd));
            } else if (as_bool(logical_eq(link, 3))) {
                current_statement_begin__ = 332;
                stan::math::assign(theta_ipd, inv_cloglog(eta_ipd));
            }
            current_statement_begin__ = 335;
            if (as_bool(ni_agd_arm)) {
                current_statement_begin__ = 336;
                if (as_bool(logical_gt(nint, 1))) {
                    current_statement_begin__ = 337;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 338;
                        validate_non_negative_index("eta_agd_arm_noRE", "(nint * ni_agd_arm)", (nint * ni_agd_arm));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_arm_noRE((nint * ni_agd_arm));
                        stan::math::initialize(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_arm_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_arm, beta_tilde)) ));
                        current_statement_begin__ = 342;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 343;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 344;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 345;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_logit(add(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE"), get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_ii");
                                } else {
                                    current_statement_begin__ = 347;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_logit(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE")), 
                                                "assigning variable theta_agd_arm_ii");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 350;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 351;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 352;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                Phi(add(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE"), get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_ii");
                                } else {
                                    current_statement_begin__ = 354;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                Phi(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE")), 
                                                "assigning variable theta_agd_arm_ii");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 357;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 358;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 359;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_cloglog(add(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE"), get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_ii");
                                } else {
                                    current_statement_begin__ = 361;
                                    stan::model::assign(theta_agd_arm_ii, 
                                                stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), 
                                                inv_cloglog(stan::model::rvalue(eta_agd_arm_noRE, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "eta_agd_arm_noRE")), 
                                                "assigning variable theta_agd_arm_ii");
                                }
                            }
                        }
                        }
                    } else {
                        current_statement_begin__ = 365;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 366;
                            stan::math::assign(theta_agd_arm_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_logit(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_logit(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 370;
                            stan::math::assign(theta_agd_arm_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(Phi(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(Phi(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 374;
                            stan::math::assign(theta_agd_arm_ii, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(multiply(X_agd_arm, beta_tilde))) ));
                        }
                    }
                    current_statement_begin__ = 380;
                    for (int i = 1; i <= ni_agd_arm; ++i) {
                        current_statement_begin__ = 381;
                        stan::model::assign(theta_agd_arm_bar, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    mean(stan::model::rvalue(theta_agd_arm_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "theta_agd_arm_ii")), 
                                    "assigning variable theta_agd_arm_bar");
                        current_statement_begin__ = 382;
                        stan::model::assign(theta2_agd_arm_bar, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (dot_self(stan::model::rvalue(theta_agd_arm_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (i * nint)), stan::model::nil_index_list()), "theta_agd_arm_ii")) / nint), 
                                    "assigning variable theta2_agd_arm_bar");
                        current_statement_begin__ = 385;
                        stan::model::assign(nprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(agd_arm_n, i, "agd_arm_n", 1) * pow(get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1), 2)) / get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1)), 
                                    "assigning variable nprime");
                        current_statement_begin__ = 386;
                        stan::model::assign(pprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1) / get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1)), 
                                    "assigning variable pprime");
                        current_statement_begin__ = 389;
                        if (as_bool(logical_lt(get_base1(nprime, i, "nprime", 1), get_base1(agd_arm_r, i, "agd_arm_r", 1)))) {
                            current_statement_begin__ = 389;
                            std::stringstream errmsg_stream__;
                            errmsg_stream__ << "nprime = ";
                            errmsg_stream__ << get_base1(nprime, i, "nprime", 1);
                            errmsg_stream__ << " less than r = ";
                            errmsg_stream__ << get_base1(agd_arm_r, i, "agd_arm_r", 1);
                            throw std::domain_error(errmsg_stream__.str());
                        }
                    }
                } else {
                    current_statement_begin__ = 392;
                    if (as_bool(RE)) {
                        {
                        current_statement_begin__ = 393;
                        validate_non_negative_index("eta_agd_arm_noRE", "(nint * ni_agd_arm)", (nint * ni_agd_arm));
                        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eta_agd_arm_noRE((nint * ni_agd_arm));
                        stan::math::initialize(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::fill(eta_agd_arm_noRE, DUMMY_VAR__);
                        stan::math::assign(eta_agd_arm_noRE,(has_offset ? stan::math::promote_scalar<local_scalar_t__>(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm)) : stan::math::promote_scalar<local_scalar_t__>(multiply(X_agd_arm, beta_tilde)) ));
                        current_statement_begin__ = 397;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 398;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 399;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 400;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_logit((get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1) + get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_bar");
                                } else {
                                    current_statement_begin__ = 402;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_logit(get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1)), 
                                                "assigning variable theta_agd_arm_bar");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 405;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 406;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 407;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                Phi((get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1) + get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_bar");
                                } else {
                                    current_statement_begin__ = 409;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                Phi(get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1)), 
                                                "assigning variable theta_agd_arm_bar");
                                }
                            }
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 412;
                            for (int i = 1; i <= ni_agd_arm; ++i) {
                                current_statement_begin__ = 413;
                                if (as_bool(get_base1(which_RE, (narm_ipd + i), "which_RE", 1))) {
                                    current_statement_begin__ = 414;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_cloglog((get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1) + get_base1(f_delta, get_base1(which_RE, (narm_ipd + i), "which_RE", 1), "f_delta", 1))), 
                                                "assigning variable theta_agd_arm_bar");
                                } else {
                                    current_statement_begin__ = 416;
                                    stan::model::assign(theta_agd_arm_bar, 
                                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                                inv_cloglog(get_base1(eta_agd_arm_noRE, i, "eta_agd_arm_noRE", 1)), 
                                                "assigning variable theta_agd_arm_bar");
                                }
                            }
                        }
                        }
                    } else {
                        current_statement_begin__ = 420;
                        if (as_bool(logical_eq(link, 1))) {
                            current_statement_begin__ = 421;
                            stan::math::assign(theta_agd_arm_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_logit(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_logit(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 2))) {
                            current_statement_begin__ = 425;
                            stan::math::assign(theta_agd_arm_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(Phi(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(Phi(multiply(X_agd_arm, beta_tilde))) ));
                        } else if (as_bool(logical_eq(link, 3))) {
                            current_statement_begin__ = 429;
                            stan::math::assign(theta_agd_arm_bar, (has_offset ? stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(add(multiply(X_agd_arm, beta_tilde), offset_agd_arm))) : stan::math::promote_scalar<local_scalar_t__>(inv_cloglog(multiply(X_agd_arm, beta_tilde))) ));
                        }
                    }
                    current_statement_begin__ = 434;
                    stan::math::assign(theta2_agd_arm_bar, elt_multiply(theta_agd_arm_bar, theta_agd_arm_bar));
                    current_statement_begin__ = 436;
                    for (int i = 1; i <= ni_agd_arm; ++i) {
                        current_statement_begin__ = 438;
                        stan::model::assign(nprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((get_base1(agd_arm_n, i, "agd_arm_n", 1) * pow(get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1), 2)) / get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1)), 
                                    "assigning variable nprime");
                        current_statement_begin__ = 439;
                        stan::model::assign(pprime, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(theta2_agd_arm_bar, i, "theta2_agd_arm_bar", 1) / get_base1(theta_agd_arm_bar, i, "theta_agd_arm_bar", 1)), 
                                    "assigning variable pprime");
                        current_statement_begin__ = 442;
                        if (as_bool(logical_lt(get_base1(nprime, i, "nprime", 1), get_base1(agd_arm_r, i, "agd_arm_r", 1)))) {
                            current_statement_begin__ = 442;
                            std::stringstream errmsg_stream__;
                            errmsg_stream__ << "nprime = ";
                            errmsg_stream__ << get_base1(nprime, i, "nprime", 1);
                            errmsg_stream__ << " less than r = ";
                            errmsg_stream__ << get_base1(agd_arm_r, i, "agd_arm_r", 1);
                            throw std::domain_error(errmsg_stream__.str());
                        }
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 196;
            size_t nprime_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < nprime_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "nprime[i_0__]", nprime[i_0__], 0);
            }
            current_statement_begin__ = 197;
            size_t pprime_i_0_max__ = ni_agd_arm;
            for (size_t i_0__ = 0; i_0__ < pprime_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "pprime[i_0__]", pprime[i_0__], 0);
                check_less_or_equal(function__, "pprime[i_0__]", pprime[i_0__], 1);
            }
            // write transformed parameters
            if (include_tparams__) {
                size_t theta2_agd_arm_bar_j_1_max__ = ni_agd_arm;
                for (size_t j_1__ = 0; j_1__ < theta2_agd_arm_bar_j_1_max__; ++j_1__) {
                    vars__.push_back(theta2_agd_arm_bar(j_1__));
                }
                size_t nprime_k_0_max__ = ni_agd_arm;
                for (size_t k_0__ = 0; k_0__ < nprime_k_0_max__; ++k_0__) {
                    vars__.push_back(nprime[k_0__]);
                }
                size_t pprime_k_0_max__ = ni_agd_arm;
                for (size_t k_0__ = 0; k_0__ < pprime_k_0_max__; ++k_0__) {
                    vars__.push_back(pprime[k_0__]);
                }
                size_t theta_ipd_j_1_max__ = ni_ipd;
                for (size_t j_1__ = 0; j_1__ < theta_ipd_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_ipd(j_1__));
                }
                size_t theta_agd_arm_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 );
                for (size_t j_1__ = 0; j_1__ < theta_agd_arm_ii_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_agd_arm_ii(j_1__));
                }
                size_t theta_agd_arm_bar_j_1_max__ = ni_agd_arm;
                for (size_t j_1__ = 0; j_1__ < theta_agd_arm_bar_j_1_max__; ++j_1__) {
                    vars__.push_back(theta_agd_arm_bar(j_1__));
                }
                size_t eta_ipd_j_1_max__ = ni_ipd;
                for (size_t j_1__ = 0; j_1__ < eta_ipd_j_1_max__; ++j_1__) {
                    vars__.push_back(eta_ipd(j_1__));
                }
                size_t f_delta_j_1_max__ = n_delta;
                for (size_t j_1__ = 0; j_1__ < f_delta_j_1_max__; ++j_1__) {
                    vars__.push_back(f_delta(j_1__));
                }
                size_t allbeta_j_1_max__ = nX;
                for (size_t j_1__ = 0; j_1__ < allbeta_j_1_max__; ++j_1__) {
                    vars__.push_back(allbeta(j_1__));
                }
                size_t mu_j_1_max__ = totns;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    vars__.push_back(mu(j_1__));
                }
                size_t d_j_1_max__ = (nt - 1);
                for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                    vars__.push_back(d(j_1__));
                }
                size_t omega_j_1_max__ = nodesplit;
                for (size_t j_1__ = 0; j_1__ < omega_j_1_max__; ++j_1__) {
                    vars__.push_back(omega(j_1__));
                }
                size_t beta_j_1_max__ = (((nX - totns) - (nt - 1)) - nodesplit);
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    vars__.push_back(beta(j_1__));
                }
                size_t eta_agd_contrast_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 );
                for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_ii_j_1_max__; ++j_1__) {
                    vars__.push_back(eta_agd_contrast_ii(j_1__));
                }
                size_t eta_agd_contrast_bar_j_1_max__ = ni_agd_contrast;
                for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_bar_j_1_max__; ++j_1__) {
                    vars__.push_back(eta_agd_contrast_bar(j_1__));
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 509;
            validate_non_negative_index("theta2_bar_cum", "(ni_agd_arm * n_int_thin)", (ni_agd_arm * n_int_thin));
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta2_bar_cum((ni_agd_arm * n_int_thin));
            stan::math::initialize(theta2_bar_cum, DUMMY_VAR__);
            stan::math::fill(theta2_bar_cum, DUMMY_VAR__);
            current_statement_begin__ = 513;
            validate_non_negative_index("fitted_ipd", "ni_ipd", ni_ipd);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fitted_ipd(ni_ipd);
            stan::math::initialize(fitted_ipd, DUMMY_VAR__);
            stan::math::fill(fitted_ipd, DUMMY_VAR__);
            current_statement_begin__ = 514;
            validate_non_negative_index("fitted_agd_arm", "ni_agd_arm", ni_agd_arm);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fitted_agd_arm(ni_agd_arm);
            stan::math::initialize(fitted_agd_arm, DUMMY_VAR__);
            stan::math::fill(fitted_agd_arm, DUMMY_VAR__);
            current_statement_begin__ = 515;
            validate_non_negative_index("theta_bar_cum_agd_arm", "(ni_agd_arm * n_int_thin)", (ni_agd_arm * n_int_thin));
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_bar_cum_agd_arm((ni_agd_arm * n_int_thin));
            stan::math::initialize(theta_bar_cum_agd_arm, DUMMY_VAR__);
            stan::math::fill(theta_bar_cum_agd_arm, DUMMY_VAR__);
            current_statement_begin__ = 519;
            validate_non_negative_index("log_lik", "((ni_ipd + ni_agd_arm) + ns_agd_contrast)", ((ni_ipd + ni_agd_arm) + ns_agd_contrast));
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(((ni_ipd + ni_agd_arm) + ns_agd_contrast));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 520;
            validate_non_negative_index("resdev", "((ni_ipd + ni_agd_arm) + ns_agd_contrast)", ((ni_ipd + ni_agd_arm) + ns_agd_contrast));
            Eigen::Matrix<double, Eigen::Dynamic, 1> resdev(((ni_ipd + ni_agd_arm) + ns_agd_contrast));
            stan::math::initialize(resdev, DUMMY_VAR__);
            stan::math::fill(resdev, DUMMY_VAR__);
            current_statement_begin__ = 521;
            validate_non_negative_index("fitted_agd_contrast", "ni_agd_contrast", ni_agd_contrast);
            Eigen::Matrix<double, Eigen::Dynamic, 1> fitted_agd_contrast(ni_agd_contrast);
            stan::math::initialize(fitted_agd_contrast, DUMMY_VAR__);
            stan::math::fill(fitted_agd_contrast, DUMMY_VAR__);
            current_statement_begin__ = 524;
            validate_non_negative_index("theta_bar_cum_agd_contrast", "(ni_agd_contrast * n_int_thin)", (ni_agd_contrast * n_int_thin));
            Eigen::Matrix<double, Eigen::Dynamic, 1> theta_bar_cum_agd_contrast((ni_agd_contrast * n_int_thin));
            stan::math::initialize(theta_bar_cum_agd_contrast, DUMMY_VAR__);
            stan::math::fill(theta_bar_cum_agd_contrast, DUMMY_VAR__);
            current_statement_begin__ = 528;
            validate_non_negative_index("delta", "n_delta", n_delta);
            Eigen::Matrix<double, Eigen::Dynamic, 1> delta(n_delta);
            stan::math::initialize(delta, DUMMY_VAR__);
            stan::math::fill(delta, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 530;
            if (as_bool(RE)) {
                {
                current_statement_begin__ = 531;
                int s(0);
                (void) s;  // dummy to suppress unused var warning
                stan::math::fill(s, std::numeric_limits<int>::min());
                stan::math::assign(s,1);
                current_statement_begin__ = 532;
                for (int i = 1; i <= (narm_ipd + ni_agd_arm); ++i) {
                    current_statement_begin__ = 533;
                    if (as_bool(get_base1(which_RE, i, "which_RE", 1))) {
                        current_statement_begin__ = 534;
                        stan::model::assign(delta, 
                                    stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                    ((logical_gt(get_base1(trt, i, "trt", 1), 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(d, (get_base1(trt, i, "trt", 1) - 1), "d", 1)) : stan::math::promote_scalar<local_scalar_t__>(0) ) + (get_base1(which_RE, i, "which_RE", 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(f_delta, get_base1(which_RE, i, "which_RE", 1), "f_delta", 1)) : stan::math::promote_scalar<local_scalar_t__>(0) )), 
                                    "assigning variable delta");
                        current_statement_begin__ = 535;
                        stan::math::assign(s, (s + 1));
                    }
                }
                current_statement_begin__ = 538;
                for (int i = 1; i <= ni_agd_contrast; ++i) {
                    current_statement_begin__ = 539;
                    if (as_bool(get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1))) {
                        current_statement_begin__ = 540;
                        stan::model::assign(delta, 
                                    stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                    ((logical_gt(get_base1(trt, ((narm_ipd + ni_agd_arm) + i), "trt", 1), 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(d, (get_base1(trt, ((narm_ipd + ni_agd_arm) + i), "trt", 1) - 1), "d", 1)) : stan::math::promote_scalar<local_scalar_t__>(0) ) + (get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1) ? stan::math::promote_scalar<local_scalar_t__>(get_base1(f_delta, get_base1(which_RE, ((narm_ipd + ni_agd_arm) + i), "which_RE", 1), "f_delta", 1)) : stan::math::promote_scalar<local_scalar_t__>(0) )), 
                                    "assigning variable delta");
                        current_statement_begin__ = 543;
                        if (as_bool(logical_gt(get_base1(agd_contrast_trt_b, i, "agd_contrast_trt_b", 1), 1))) {
                            current_statement_begin__ = 544;
                            stan::model::assign(delta, 
                                        stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), 
                                        (stan::model::rvalue(delta, stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list()), "delta") - get_base1(d, (get_base1(agd_contrast_trt_b, i, "agd_contrast_trt_b", 1) - 1), "d", 1)), 
                                        "assigning variable delta");
                        }
                        current_statement_begin__ = 546;
                        stan::math::assign(s, (s + 1));
                    }
                }
                }
            }
            current_statement_begin__ = 552;
            for (int i = 1; i <= ni_agd_contrast; ++i) {
                current_statement_begin__ = 553;
                for (int j = 1; j <= n_int_thin; ++j) {
                    current_statement_begin__ = 554;
                    stan::model::assign(theta_bar_cum_agd_contrast, 
                                stan::model::cons_list(stan::model::index_uni((((i - 1) * n_int_thin) + j)), stan::model::nil_index_list()), 
                                mean(stan::model::rvalue(eta_agd_contrast_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (((i - 1) * nint) + (j * int_thin))), stan::model::nil_index_list()), "eta_agd_contrast_ii")), 
                                "assigning variable theta_bar_cum_agd_contrast");
                }
            }
            current_statement_begin__ = 558;
            stan::math::assign(fitted_agd_contrast, eta_agd_contrast_bar);
            {
            current_statement_begin__ = 562;
            int a(0);
            (void) a;  // dummy to suppress unused var warning
            stan::math::fill(a, std::numeric_limits<int>::min());
            stan::math::assign(a,0);
            current_statement_begin__ = 563;
            int nc(0);
            (void) nc;  // dummy to suppress unused var warning
            stan::math::fill(nc, std::numeric_limits<int>::min());
            current_statement_begin__ = 564;
            for (int s = 1; s <= ns_agd_contrast; ++s) {
                current_statement_begin__ = 565;
                stan::math::assign(nc, get_base1(nc_agd_contrast, s, "nc_agd_contrast", 1));
                current_statement_begin__ = 566;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(((ni_ipd + ni_agd_arm) + s)), stan::model::nil_index_list()), 
                            multi_normal_log(stan::model::rvalue(agd_contrast_y, stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::nil_index_list()), "agd_contrast_y"), stan::model::rvalue(eta_agd_contrast_bar, stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::nil_index_list()), "eta_agd_contrast_bar"), stan::model::rvalue(agd_contrast_Sigma, stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::nil_index_list())), "agd_contrast_Sigma")), 
                            "assigning variable log_lik");
                current_statement_begin__ = 568;
                stan::model::assign(resdev, 
                            stan::model::cons_list(stan::model::index_uni(((ni_ipd + ni_agd_arm) + s)), stan::model::nil_index_list()), 
                            quad_form(stan::model::rvalue(inv_Sigma, stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::nil_index_list())), "inv_Sigma"), subtract(stan::model::rvalue(agd_contrast_y, stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::nil_index_list()), "agd_contrast_y"), stan::model::rvalue(eta_agd_contrast_bar, stan::model::cons_list(stan::model::index_min_max((a + 1), (a + nc)), stan::model::nil_index_list()), "eta_agd_contrast_bar"))), 
                            "assigning variable resdev");
                current_statement_begin__ = 570;
                stan::math::assign(a, (a + nc));
            }
            }
            current_statement_begin__ = 578;
            for (int i = 1; i <= ni_agd_arm; ++i) {
                current_statement_begin__ = 579;
                for (int j = 1; j <= n_int_thin; ++j) {
                    current_statement_begin__ = 580;
                    stan::model::assign(theta_bar_cum_agd_arm, 
                                stan::model::cons_list(stan::model::index_uni((((i - 1) * n_int_thin) + j)), stan::model::nil_index_list()), 
                                mean(stan::model::rvalue(theta_agd_arm_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (((i - 1) * nint) + (j * int_thin))), stan::model::nil_index_list()), "theta_agd_arm_ii")), 
                                "assigning variable theta_bar_cum_agd_arm");
                }
            }
            current_statement_begin__ = 585;
            for (int i = 1; i <= ni_ipd; ++i) {
                current_statement_begin__ = 586;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            bernoulli_log(get_base1(ipd_r, i, "ipd_r", 1), get_base1(theta_ipd, i, "theta_ipd", 1)), 
                            "assigning variable log_lik");
                current_statement_begin__ = 587;
                stan::model::assign(resdev, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (-(2) * get_base1(log_lik, i, "log_lik", 1)), 
                            "assigning variable resdev");
                current_statement_begin__ = 588;
                stan::model::assign(fitted_ipd, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            get_base1(theta_ipd, i, "theta_ipd", 1), 
                            "assigning variable fitted_ipd");
            }
            current_statement_begin__ = 592;
            for (int i = 1; i <= ni_agd_arm; ++i) {
                current_statement_begin__ = 593;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni((ni_ipd + i)), stan::model::nil_index_list()), 
                            ((binomial_coefficient_log(get_base1(nprime, i, "nprime", 1), get_base1(agd_arm_r, i, "agd_arm_r", 1)) + multiply_log(get_base1(agd_arm_r, i, "agd_arm_r", 1), get_base1(pprime, i, "pprime", 1))) + ((get_base1(nprime, i, "nprime", 1) - get_base1(agd_arm_r, i, "agd_arm_r", 1)) * log1m(get_base1(pprime, i, "pprime", 1)))), 
                            "assigning variable log_lik");
                current_statement_begin__ = 597;
                stan::model::assign(resdev, 
                            stan::model::cons_list(stan::model::index_uni((ni_ipd + i)), stan::model::nil_index_list()), 
                            (2 * (multiply_log(get_base1(agd_arm_r, i, "agd_arm_r", 1), (get_base1(agd_arm_r, i, "agd_arm_r", 1) / (get_base1(nprime, i, "nprime", 1) * get_base1(pprime, i, "pprime", 1)))) + multiply_log((get_base1(agd_arm_n, i, "agd_arm_n", 1) - get_base1(agd_arm_r, i, "agd_arm_r", 1)), ((get_base1(agd_arm_n, i, "agd_arm_n", 1) - get_base1(agd_arm_r, i, "agd_arm_r", 1)) / (get_base1(agd_arm_n, i, "agd_arm_n", 1) - (get_base1(nprime, i, "nprime", 1) * get_base1(pprime, i, "pprime", 1))))))), 
                            "assigning variable resdev");
                current_statement_begin__ = 601;
                stan::model::assign(fitted_agd_arm, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(nprime, i, "nprime", 1) * get_base1(pprime, i, "pprime", 1)), 
                            "assigning variable fitted_agd_arm");
                current_statement_begin__ = 603;
                for (int j = 1; j <= n_int_thin; ++j) {
                    current_statement_begin__ = 604;
                    stan::model::assign(theta2_bar_cum, 
                                stan::model::cons_list(stan::model::index_uni((((i - 1) * n_int_thin) + j)), stan::model::nil_index_list()), 
                                (dot_self(stan::model::rvalue(theta_agd_arm_ii, stan::model::cons_list(stan::model::index_min_max((1 + ((i - 1) * nint)), (((i - 1) * nint) + (j * int_thin))), stan::model::nil_index_list()), "theta_agd_arm_ii")) / (j * int_thin)), 
                                "assigning variable theta2_bar_cum");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 509;
            size_t theta2_bar_cum_j_1_max__ = (ni_agd_arm * n_int_thin);
            for (size_t j_1__ = 0; j_1__ < theta2_bar_cum_j_1_max__; ++j_1__) {
                vars__.push_back(theta2_bar_cum(j_1__));
            }
            current_statement_begin__ = 513;
            size_t fitted_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < fitted_ipd_j_1_max__; ++j_1__) {
                vars__.push_back(fitted_ipd(j_1__));
            }
            current_statement_begin__ = 514;
            size_t fitted_agd_arm_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < fitted_agd_arm_j_1_max__; ++j_1__) {
                vars__.push_back(fitted_agd_arm(j_1__));
            }
            current_statement_begin__ = 515;
            size_t theta_bar_cum_agd_arm_j_1_max__ = (ni_agd_arm * n_int_thin);
            for (size_t j_1__ = 0; j_1__ < theta_bar_cum_agd_arm_j_1_max__; ++j_1__) {
                vars__.push_back(theta_bar_cum_agd_arm(j_1__));
            }
            current_statement_begin__ = 519;
            size_t log_lik_j_1_max__ = ((ni_ipd + ni_agd_arm) + ns_agd_contrast);
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
            current_statement_begin__ = 520;
            size_t resdev_j_1_max__ = ((ni_ipd + ni_agd_arm) + ns_agd_contrast);
            for (size_t j_1__ = 0; j_1__ < resdev_j_1_max__; ++j_1__) {
                vars__.push_back(resdev(j_1__));
            }
            current_statement_begin__ = 521;
            size_t fitted_agd_contrast_j_1_max__ = ni_agd_contrast;
            for (size_t j_1__ = 0; j_1__ < fitted_agd_contrast_j_1_max__; ++j_1__) {
                vars__.push_back(fitted_agd_contrast(j_1__));
            }
            current_statement_begin__ = 524;
            size_t theta_bar_cum_agd_contrast_j_1_max__ = (ni_agd_contrast * n_int_thin);
            for (size_t j_1__ = 0; j_1__ < theta_bar_cum_agd_contrast_j_1_max__; ++j_1__) {
                vars__.push_back(theta_bar_cum_agd_contrast(j_1__));
            }
            current_statement_begin__ = 528;
            size_t delta_j_1_max__ = n_delta;
            for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
                vars__.push_back(delta(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_binomial_2par";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_tilde_j_1_max__ = nX;
        for (size_t j_1__ = 0; j_1__ < beta_tilde_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_tilde" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < u_delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = (RE ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta2_agd_arm_bar_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < theta2_agd_arm_bar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta2_agd_arm_bar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t nprime_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < nprime_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "nprime" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t pprime_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < pprime_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pprime" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < theta_ipd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_ipd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_agd_arm_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_agd_arm_ii_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_agd_arm_ii" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_agd_arm_bar_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < theta_agd_arm_bar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_agd_arm_bar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < eta_ipd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_ipd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t f_delta_j_1_max__ = n_delta;
            for (size_t j_1__ = 0; j_1__ < f_delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f_delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t allbeta_j_1_max__ = nX;
            for (size_t j_1__ = 0; j_1__ < allbeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "allbeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = totns;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t d_j_1_max__ = (nt - 1);
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "d" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t omega_j_1_max__ = nodesplit;
            for (size_t j_1__ = 0; j_1__ < omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "omega" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = (((nX - totns) - (nt - 1)) - nodesplit);
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_agd_contrast_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 );
            for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_ii_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_agd_contrast_ii" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_agd_contrast_bar_j_1_max__ = ni_agd_contrast;
            for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_bar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_agd_contrast_bar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t theta2_bar_cum_j_1_max__ = (ni_agd_arm * n_int_thin);
        for (size_t j_1__ = 0; j_1__ < theta2_bar_cum_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta2_bar_cum" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fitted_ipd_j_1_max__ = ni_ipd;
        for (size_t j_1__ = 0; j_1__ < fitted_ipd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fitted_ipd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fitted_agd_arm_j_1_max__ = ni_agd_arm;
        for (size_t j_1__ = 0; j_1__ < fitted_agd_arm_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fitted_agd_arm" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_bar_cum_agd_arm_j_1_max__ = (ni_agd_arm * n_int_thin);
        for (size_t j_1__ = 0; j_1__ < theta_bar_cum_agd_arm_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_bar_cum_agd_arm" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = ((ni_ipd + ni_agd_arm) + ns_agd_contrast);
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t resdev_j_1_max__ = ((ni_ipd + ni_agd_arm) + ns_agd_contrast);
        for (size_t j_1__ = 0; j_1__ < resdev_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "resdev" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fitted_agd_contrast_j_1_max__ = ni_agd_contrast;
        for (size_t j_1__ = 0; j_1__ < fitted_agd_contrast_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fitted_agd_contrast" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_bar_cum_agd_contrast_j_1_max__ = (ni_agd_contrast * n_int_thin);
        for (size_t j_1__ = 0; j_1__ < theta_bar_cum_agd_contrast_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_bar_cum_agd_contrast" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t beta_tilde_j_1_max__ = nX;
        for (size_t j_1__ = 0; j_1__ < beta_tilde_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_tilde" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t u_delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < u_delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "u_delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = (RE ? 1 : 0 );
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "tau" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta2_agd_arm_bar_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < theta2_agd_arm_bar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta2_agd_arm_bar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t nprime_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < nprime_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "nprime" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t pprime_k_0_max__ = ni_agd_arm;
            for (size_t k_0__ = 0; k_0__ < pprime_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "pprime" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < theta_ipd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_ipd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_agd_arm_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_arm) : 0 );
            for (size_t j_1__ = 0; j_1__ < theta_agd_arm_ii_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_agd_arm_ii" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t theta_agd_arm_bar_j_1_max__ = ni_agd_arm;
            for (size_t j_1__ = 0; j_1__ < theta_agd_arm_bar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_agd_arm_bar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_ipd_j_1_max__ = ni_ipd;
            for (size_t j_1__ = 0; j_1__ < eta_ipd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_ipd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t f_delta_j_1_max__ = n_delta;
            for (size_t j_1__ = 0; j_1__ < f_delta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "f_delta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t allbeta_j_1_max__ = nX;
            for (size_t j_1__ = 0; j_1__ < allbeta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "allbeta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t mu_j_1_max__ = totns;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mu" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t d_j_1_max__ = (nt - 1);
            for (size_t j_1__ = 0; j_1__ < d_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "d" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t omega_j_1_max__ = nodesplit;
            for (size_t j_1__ = 0; j_1__ < omega_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "omega" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t beta_j_1_max__ = (((nX - totns) - (nt - 1)) - nodesplit);
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "beta" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_agd_contrast_ii_j_1_max__ = (logical_gt(nint, 1) ? (nint * ni_agd_contrast) : 0 );
            for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_ii_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_agd_contrast_ii" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t eta_agd_contrast_bar_j_1_max__ = ni_agd_contrast;
            for (size_t j_1__ = 0; j_1__ < eta_agd_contrast_bar_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "eta_agd_contrast_bar" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
        size_t theta2_bar_cum_j_1_max__ = (ni_agd_arm * n_int_thin);
        for (size_t j_1__ = 0; j_1__ < theta2_bar_cum_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta2_bar_cum" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fitted_ipd_j_1_max__ = ni_ipd;
        for (size_t j_1__ = 0; j_1__ < fitted_ipd_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fitted_ipd" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fitted_agd_arm_j_1_max__ = ni_agd_arm;
        for (size_t j_1__ = 0; j_1__ < fitted_agd_arm_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fitted_agd_arm" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_bar_cum_agd_arm_j_1_max__ = (ni_agd_arm * n_int_thin);
        for (size_t j_1__ = 0; j_1__ < theta_bar_cum_agd_arm_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_bar_cum_agd_arm" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log_lik_j_1_max__ = ((ni_ipd + ni_agd_arm) + ns_agd_contrast);
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t resdev_j_1_max__ = ((ni_ipd + ni_agd_arm) + ns_agd_contrast);
        for (size_t j_1__ = 0; j_1__ < resdev_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "resdev" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t fitted_agd_contrast_j_1_max__ = ni_agd_contrast;
        for (size_t j_1__ = 0; j_1__ < fitted_agd_contrast_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "fitted_agd_contrast" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t theta_bar_cum_agd_contrast_j_1_max__ = (ni_agd_contrast * n_int_thin);
        for (size_t j_1__ = 0; j_1__ < theta_bar_cum_agd_contrast_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "theta_bar_cum_agd_contrast" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t delta_j_1_max__ = n_delta;
        for (size_t j_1__ = 0; j_1__ < delta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "delta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_binomial_2par_namespace::model_binomial_2par stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
