% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_to.R
\name{count_to_bf}
\alias{count_to_bf}
\title{Compute Bayes Factor Using Prior/Posterior Counts}
\usage{
count_to_bf(posterior, prior, exact_prior, log = FALSE, beta = c(1/2,
  1/2), samples = 3000)
}
\arguments{
\item{posterior}{a vector (or matrix) with entries (or columns)
\code{count} = number of posterior samples within polytope and \code{M} =
total number of samples. See \code{\link{count_binom}}.}

\item{prior}{a vecotr or matrix similar as for \code{posterior}, but based on
samples from the prior distribution.}

\item{exact_prior}{optional: the exact prior probabability of the order constraints.
For instance, \code{exact_prior=1/factorial(4)} if pi1<pi2<pi3<pi4 (and if  the prior is symmetric).
If provided, \code{prior} is ignored.}

\item{log}{whether to return the log-Bayes factor instead of the Bayes factor}

\item{beta}{prior shape parameters of the beta distributions used for approximating the
standard errors of the Bayes-factor estimates. The default is Jeffreys' prior.}

\item{samples}{number of samples from beta distributions used to compute
   standard errors.


The unconstrained (encompassing) model is the saturated baseline model that assumes a separate,
independent probability for each observable frequency. The Bayes factor is obtained
as the ratio of posterior/prior samples within an order-constrained subset of the
parameter space.

The standard error of the (stepwise) encompassing Bayes factor is estimated by sampling
ratios from beta distributions, with parameters defined by the posterior/prior counts
(see Hoijtink, 2011; p. 211).}
}
\value{
a matrix with two columns (Bayes factor and SE of approximation) and three rows:
    \itemize{
      \item \code{`bf_0u`}:  constrained vs. unconstrained (saturated) model
      \item \code{`bf_u0`}:  unconstrained vs. constrained model
      \item \code{`bf_00'`}: constrained vs. complement of inequality-constrained model
             (e.g., pi>.2 becomes pi<=.2; this assumes identical equality constraints for both models)
    }
}
\description{
Computes the encompassing Bayes factor (and standard error) defined as the
ratio of posterior/prior samples that satisfy the order constraints (e.g., of a polytope).
}
\examples{
# vector input
post  <- c(count = 1447, M = 5000)
prior <- c(count = 152,  M = 10000)
count_to_bf(post, prior)

# matrix input (due to nested stepwise procedure)
post <- cbind(count = c(139, 192), M = c(200, 1000))
count_to_bf(post, prior)

# exact prior probability known
count_to_bf(posterior = c(count = 1447, M = 10000),
            exact_prior = 1/factorial(4))
}
\references{
Hoijtink, H. (2011). Informative Hypotheses: Theory and Practice for Behavioral and Social Scientists. Boca Raton, FL: Chapman & Hall/CRC.
}
\seealso{
\code{\link{count_binom}}, \code{\link{count_multinom}}
}
