% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochdom_bf.R
\name{stochdom_bf}
\alias{stochdom_bf}
\title{Bayes Factor for Stochastic Dominance of Continuous Distributions}
\usage{
stochdom_bf(x1, x2, breaks = "Sturges", order = "<", ...)
}
\arguments{
\item{x1}{a vector with samples from the first random variable/experimental condition.}

\item{x2}{a vector with samples from the second random variable/experimental condition.}

\item{breaks}{number of bins of histogram. See \code{\link[graphics]{hist}}.}

\item{order}{order constraint on the random variables across conditions.
The default \code{order="<"} implies that the random variables increase across
conditions (implying that the cdfs decrease: \eqn{F_1(t) > F_2(t)}).}

\item{...}{further arguments passed to \code{\link{bf_multinom}}. Note that the
noninformative default prior \code{1/number_of_bins} is used.}
}
\description{
Uses discrete bins (as in a histogram) to compute the Bayes factor in favor
of stochastic dominance of continuous distributions.
}
\examples{
x1 <- rnorm(300, 0, 1)
x2 <- rnorm(300, .5, 1)  # dominates x1
x3 <- rnorm(300, 0, 1.2) # intersects x1

plot(ecdf(x1))
lines(ecdf(x2), col = "red")
lines(ecdf(x3), col = "blue")

b12 <- stochdom_bf(x1, x2, order = "<", M =5e4)
b13 <- stochdom_bf(x1, x3, order = "<", M =5e4)
b12$bf
b13$bf
}
\references{
Heathcote, A., Brown, S., Wagenmakers, E. J., & Eidels, A. (2010). Distribution-free tests of stochastic dominance for small samples. Journal of Mathematical Psychology, 54(5), 454-463. \url{https://doi.org/10.1016/j.jmp.2010.06.005}
}
