% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy_multiattribute.R
\name{strategy_to_Ab}
\alias{strategy_to_Ab}
\title{Transform Pattern of Predictions to Polytope}
\usage{
strategy_to_Ab(strategy)
}
\arguments{
\item{strategy}{a decision strategy returned by \code{\link{strategy_multiattribute}}.}
}
\value{
a list containing the matrix \code{A} and the vector \code{b}
     that define a polytope via \code{A*x <= b}.
}
\description{
Transforms ordered item-type predictions to polytope definition.
This allows to use Monte-Carlo methods to compute the Bayes factor
if the number of item types is large (\code{\link{bf_binom}}).
}
\details{
Note: Only works for models without guessing predictions and
without equality constraints (i.e., requires separate error probabilities per item type)
}
\examples{
# strategy:  A,B,B,A   e2<e3<e4<e1<.50
strat <- list(pattern = c(-1,4,3,-2),
              c = .5, ordered = TRUE,
              prior = c(1,1))
pt <- strategy_to_Ab(strat)
pt

# compare results to encompassing BF method:
b <- list(pattern = 1:4, c = 1,
          ordered = FALSE, prior = c(1,1))
k <- c(2, 20, 18, 0)
n <- rep(20, 4)
m1 <- strategy_postprob(k, n, list(strat, b))
log(m1[1] / m1[2])
bf_binom(k, n, pt$A, pt$b, log = TRUE)
}
