% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourmvd.R
\name{contourmvd}
\alias{contourmvd}
\title{Contour Plot of a Bivariate Density}
\usage{
contourmvd(mu, Sigma, beta = NULL, nu = NULL,
                  distribution = c("mggd", "mcd", "mtd"),
                  xlim = c(mu[1] + c(-10, 10)*Sigma[1, 1]),
                  ylim = c(mu[2] + c(-10, 10)*Sigma[2, 2]),
                  zlim = NULL, npt = 30, nx = npt, ny = npt,
                  main = NULL, sub = NULL, nlevels = 10,
                  levels = pretty(zlim, nlevels), tol = 1e-6, ...)
}
\arguments{
\item{mu}{length 2 numeric vector.}

\item{Sigma}{symmetric, positive-definite square matrix of order 2. The dispersion matrix.}

\item{beta}{numeric. If \code{distribution = "mggd"}, the shape parameter of the MGGD.
\code{NULL} if \code{dist} is \code{"mcd"} or \code{"mtd"}.}

\item{nu}{numeric. If \code{distribution = "mtd"}, the degrees of freedom of the MTD.
\code{NULL} if \code{distribution} is \code{"mggd"} or \code{"mcd"}.}

\item{distribution}{character string. The probability distribution. It can be \code{"mggd"} (multivariate generalized Gaussian distribution) \code{"mcd"} (multivariate Cauchy) or \code{"mtd"} (multivariate \eqn{t}).}

\item{xlim, ylim}{x-and y- limits.}

\item{zlim}{z- limits. If NULL, it is the range of the values of the density on the x and y values within \code{xlim} and \code{ylim}.}

\item{npt}{number of points for the discretisation.}

\item{nx, ny}{number of points for the discretisation among the x- and y- axes.}

\item{main, sub}{main and sub title, as for \code{\link{title}}.
If omitted, the main title is set to \code{"Multivariate generalised Gaussian density"},
\code{"Multivariate Cauchy density"} or \code{"Multivariate t density"}.}

\item{nlevels, levels}{arguments to be passed to the \code{\link{contour}} function.}

\item{tol}{tolerance (relative to largest variance) for numerical lack of positive-definiteness in Sigma, for the estimation of the density. See \code{\link{dmggd}}, \code{\link{dmcd}} or \code{\link{dmtd}}.}

\item{...}{additional arguments to \code{\link{plot.window}}, \code{\link{title}}, \code{\link{Axis}} and \code{\link{box}}, typically \link{graphical parameters} such as \code{cex.axis}.}
}
\value{
Returns invisibly the probability density function.
}
\description{
Contour plot of the probability density of a multivariate distribution with 2 variables:
\itemize{
\item generalized Gaussian distribution (MGGD) with mean vector \code{mu}, dispersion matrix \code{Sigma} and shape parameter \code{beta}
\item Cauchy distribution (MCD) with location parameter \code{mu} and scatter matrix \code{Sigma}
\item \eqn{t} distribution (MTD) with location parameter \code{mu}, scatter matrix \code{Sigma} and degrees of freedom \code{nu}
}
This function uses the \code{\link{contour}} function.
}
\examples{
mu <- c(1, 4)
Sigma <- matrix(c(0.8, 0.2, 0.2, 0.2), nrow = 2)

# Bivariate generalized Gaussian distribution
beta <- 0.74
contourmvd(mu, Sigma, beta = beta, distribution = "mggd")

# Bivariate Cauchy distribution
contourmvd(mu, Sigma, distribution = "mcd")

# Bivariate t distribution
nu <- 1
contourmvd(mu, Sigma, nu = nu, distribution = "mtd")

}
\references{
E. Gomez, M. Gomez-Villegas, H. Marin. A Multivariate Generalization of the Power Exponential Family of Distribution.
Commun. Statist. 1998, Theory Methods, col. 27, no. 23, p 589-600.
\doi{10.1080/03610929808832115}

S. Kotz and Saralees Nadarajah (2004), Multivariate \eqn{t} Distributions and Their Applications, Cambridge University Press.
}
\seealso{
\code{\link{plotmvd}}: plot of a bivariate generalised Gaussian, Cauchy or \eqn{t} density.

\code{\link{dmggd}}: probability density of a multivariate generalised Gaussian distribution.

\code{\link{dmcd}}: probability density of a multivariate Cauchy distribution.

\code{\link{dmtd}}: probability density of a multivariate \eqn{t} distribution.
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
