% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawdata.R
\name{rawdata}
\alias{rawdata}
\title{Import ASCII data into R}
\usage{
rawdata(path_cycles = NA, path_emg = NA, header_cycles, header_emg = TRUE)
}
\arguments{
\item{path_cycles}{Optional, path where cycle timing files are located}

\item{path_emg}{Optional, path where raw EMG files are located}

\item{header_cycles}{Logical, are the cycle-ASCII files containing a named header (optional)?}

\item{header_emg}{Logical, are the raw EMG-ASCII files containing a named header (they should)?}
}
\value{
List of objects of class \code{EMG}, each with elements:\cr
\itemize{
\item \code{cycles} data frame containing cycle timings, with as many columns as many cycle subdivisions are wanted\cr
\item \code{emg} data frame containing raw EMG data in columns, first column must be time in the same units as in the cycle timings
}
}
\description{
Import ASCII data into R
}
\details{
Supported are tab- or comma-separated files readable through \code{read.table()} or \code{read.csv()}.
The first column of each raw emg file must be time in the same units as those used for the
cycle timings (e.g., [s] or [ms]).
}
\examples{
# Load built-in data set
data("RAW_DATA")

# Get current working directory
data_path <- getwd()
data_path <- paste0(data_path, .Platform$file.sep)

# Create two conveniently-named subfolders if they don't already exist
# (if they exist, please make sure they're empty!)
dir.create("cycles", showWarnings = FALSE)
dir.create("emg", showWarnings = FALSE)

# Export ASCII data from built-in data set to the new subfolders
write.table(RAW_DATA[[1]]$cycles,
  file = paste0(data_path, "cycles", .Platform$file.sep, names(RAW_DATA)[1], ".txt"),
  sep = "\t", row.names = FALSE
)
write.table(RAW_DATA[[1]]$emg,
  file = paste0(data_path, "emg", .Platform$file.sep, names(RAW_DATA)[1], ".txt"),
  sep = "\t", row.names = FALSE
)

# Run the function to parse ASCII files into objects of class `EMG`
raw_data_from_files <- rawdata(
  path_cycles = paste0(data_path, "/cycles/"),
  path_emg = paste0(data_path, "/emg/"),
  header_cycles = FALSE
)

# Check data in the new folders if needed before running the following (will delete!)

# Delete folders
unlink("cycles", recursive = TRUE)
unlink("emg", recursive = TRUE)
}
