% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{playProgression}
\alias{playProgression}
\title{Play Progression}
\usage{
playProgression(progression, oscillator = c("sine", "square", "saw",
  "triangle"), duration = 1, BPM = 120, sample.rate = 44100,
  attack.time = 50, inner.release.time = 50, A4 = 440,
  plot = FALSE, ...)
}
\arguments{
\item{progression}{List of string vectors: Each element of the list is a chord.
e.g. output of \link{buildProgression}}

\item{oscillator}{String: "sine", "square", "saw". Default = "sine"}

\item{duration}{Float: Note duration in beats. Default = 1}

\item{BPM}{Integer: Beats per minute. Default = 120}

\item{sample.rate}{Integer: Sample rate. Default = 44100}

\item{attack.time}{Integer: Attack time. Default = 50 (Helps prevent popping)}

\item{inner.release.time}{Integer: Release time, that ends on note OFF (instead of beginning at note OFF).
Default = 50 (Also helps prevent popping)}

\item{A4}{Float: Frequency for A4 in Hz. Default = 440}

\item{plot}{Logical. If TRUE, plot each chord in the progression using \link{cplot.piano}}

\item{...}{Additional arguments to pass to \link{note2freq}}
}
\description{
Play Progression
}
\examples{
\dontrun{
playProgression(buildProgression("G4", "minor"))
}
}
\author{
Efstathios D. Gennatas
}
