% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{convert}
\alias{convert}
\title{Convert between octave measurements}
\usage{
convert(x, edo1, edo2)
}
\arguments{
\item{x}{The set to convert as a numeric vector.}

\item{edo1}{The size of the period measured in the same units
as the input \code{x}. Numeric.}

\item{edo2}{The period size to convert to. Numeric.}
}
\value{
A numeric vector the same length as \code{x}
representing the input set converted to the desired cardinality (\code{edo2}).
}
\description{
By default the period of a scale (normally the octave)
has a size of 12 units (semitones). But it can be useful
to convert to a different measurement unit, e.g. to compare
a scale defined in 19-tone equal temperament (19edo) to the
size of its intervals when measured in normal 12edo semitones,
or vice versa.
}
\examples{
maqam_rast <- c(0, 2, 3.5, 5, 7, 9, 10.5)
convert(maqam_rast, 12, 24)

perfect_fifth <- z(3/2)
lydian_scale <- sort((perfect_fifth * (0:6)) \%\% 12)
convert(lydian_scale, 12, 53)

}
