% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propriety.R
\name{isproper}
\alias{isproper}
\alias{has_contradiction}
\alias{strictly_proper}
\title{Rothenberg propriety}
\usage{
isproper(set, strict = FALSE, edo = 12, rounder = 10)

has_contradiction(set, edo = 12, rounder = 10)

strictly_proper(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{strict}{Boolean: should only strictly proper scales pass?}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Boolean which answers whether the input satisfies the property named by the
function
}
\description{
Rothenberg (1978) \url{doi:10.1007/BF01768477} identifies a potentially
desirable trait for scales which he calls "propriety." Loosely speaking,
a scale is proper if its specific intervals are well sorted in terms of the
generic intervals they belong to. A scale is \emph{strictly} proper if, given
two generic sizes g and h such that g < h, every specific size corresponding
to g is smaller than every specific size corresponding to h. A scale if
improper if any specific size of g is larger than any specific size of h.
An \emph{ambiguity} occurs if any size of g equals any size of h: scales with
ambiguities are weakly but not strictly proper.
}
\examples{
c_major <- c(0, 2, 4, 5, 7, 9, 11)
has_contradiction(c_major)
strictly_proper(c_major)
isproper(c_major)
isproper(c_major, strict=TRUE)

isproper(j(dia), strict=TRUE)

pythagorean_diatonic <- sort(((0:6)*z(3/2))\%\%12)
isproper(pythagorean_diatonic)
has_contradiction(pythagorean_diatonic)

}
\seealso{
\code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}} creates an \code{ineqmat} for a hyperplane arrangement
that lets you explore propriety-related issues in finer detail.
}
