% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets.R
\name{subset_multiplicities}
\alias{subset_multiplicities}
\title{Count the multiplicities of a subset-type's varieties}
\usage{
subset_multiplicities(
  subsetdegrees,
  set,
  edo = 12,
  rounder = 10,
  display_digits = 2
)
}
\arguments{
\item{subsetdegrees}{Vector of integers indicating the generic shape to use, e.g. \code{c(0, 2, 4)} for
tertian triads in a heptachord. Expected to begin with \code{0} and must have length > 1.}

\item{set}{The scale to find subsets of, as a numeric vector}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}

\item{display_digits}{Integer: how many digits to display when naming any
non-integral interval sizes. Defaults to 2.}
}
\value{
Numeric vector whose names indicate the \code{k} varieties of the subset type and whose
entries count how often each variety occurs.
}
\description{
Given the varieties of a subset type returned by \code{\link[=subset_varieties]{subset_varieties()}}, \code{subset_multiplicities()}
counts how many times each one occurs in the scale. These are the multiplicities of the subsets
in the sense of \href{https://www.jstor.org/stable/843615}{Clough and Myerson (1985)'s}
result "structure yields multiplicity" for well-formed scales.
}
\examples{
subset_multiplicities(c(0, 2, 4), sc(7, 35))
subset_multiplicities(c(0, 1, 4), sc(7, 35))

subset_multiplicities(c(0, 2, 4), j(dia))

}
