% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_likelihood.R
\name{spectralLikelihood}
\alias{spectralLikelihood}
\title{Spectral log-likelihood function}
\usage{
spectralLikelihood(obs, loc, vario, nCores = 1, cl = NULL)
}
\arguments{
\item{obs}{A list of observations vectors for which \code{sum(x)} exceeds a high threshold.}

\item{loc}{A matrix of coordinates as given by \code{expand.grid()}.}

\item{vario}{A semi-variogram function taking a vector of coordinates as input.}

\item{nCores}{The number of cores used for the computation}

\item{cl}{A cluster instance as created by \code{makeCluster} of the \code{parallel} package.}
}
\value{
Value of the log-likelihood function for the set of observations \code{obs} and semi-variogram \code{vario}.
}
\description{
Compute the spectral log-likelihood function for Brown--Resnick model with peaks-over-threhold
}
\details{
The function compute the log-likelihood function based on the spectral representation developped
by Engelelke et al. (2015). This simplified expression is obtained by conditioning on the event
`\code{sum(x)} exceeds a high threshold \code{u > 1}'. Margins must have been standardized.
}
\examples{
#Define variogram function
vario <- function(h){
   1 / 2 * norm(h,type = "2")^1.5
}

#Define locations
loc <- expand.grid(1:4, 1:4)

#Simulate data
obs <- simulPareto(1000, loc, vario)

#Compute cost function series
sums <- sapply(obs, sum)

#Select exceedances
exceedances <- obs[sums > quantile(sums, 0.9)]

#Compute log-likelihood function
spectralLikelihood(exceedances, loc, vario)
}
\references{
Engelke, S. et al. (2015). Estimation of Huesler-Reiss Distributions and Brown-Resnick Processes. Journal of the Royal Statistical Society: Series B, 77(1):239-265
}

