% Generated by roxygen2 (4.0.0.99): do not edit by hand
\name{image.mvcwt}
\alias{image.mvcwt}
\title{Draw a heatmap of a \code{\link{mvcwt}} object}
\usage{
\method{image}{mvcwt}(x, z.fun = "Re", bound = 1, reset.par = TRUE, ...)
}
\arguments{
\item{x}{an object as returned by \code{\link{mvcwt}}}

\item{z.fun}{a function applied to the data before plotting}

\item{bound}{if finite, draw lines \code{bound * scale} units inside the
plot boundaries}

\item{reset.par}{if true, reset graphical parameters on exit}

\item{\dots}{additional arguments passed to \code{\link{image}}}
}
\value{
\code{x} is returned invisibly
}
\description{
Draws one or more heatmaps
}
\details{
This function will draw a series of heatmaps on the graphical device. If you
want to add additional graphical elements, set \code{reset.par} to false.
}
\examples{
\dontrun{
data(lrlake)
x = subset(lrlake, Basin == "Treatment", LRL.Day) / 365.25
y = subset(lrlake, Basin == "Treatment", -(1:8))
w = mvcwt(x, y, min.scale = 0.25, max.scale = 4)
image(w, z.fun = "Mod")}
}
\author{
Timothy H. Keitt
}
\seealso{
\code{\link{mvcwt}}, \code{\link{wmr}}
}
\keyword{graphics}

