% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fevd.mvgam.R
\name{fevd.mvgam}
\alias{fevd.mvgam}
\alias{fevd}
\title{Calculate latent VAR forecast error variance decompositions}
\usage{
fevd(object, ...)

\method{fevd}{mvgam}(object, h = 10, ...)
}
\arguments{
\item{object}{\code{list} object of class \code{mvgam} resulting from a call to \code{\link[=mvgam]{mvgam()}}
that used a Vector Autoregressive latent process model (either as \code{VAR(cor = FALSE)} or
\code{VAR(cor = TRUE)}; see \code{\link[=VAR]{VAR()}} for details)}

\item{...}{ignored}

\item{h}{Positive \code{integer} specifying the forecast horizon over which to calculate
the IRF}
}
\value{
See \code{\link{mvgam_fevd-class}} for a full description of the quantities that are
computed and returned by this function, along with key references.
}
\description{
Compute forecast error variance decompositions from
\code{mvgam} models with Vector Autoregressive dynamics
}
\examples{
\donttest{
# Simulate some time series that follow a latent VAR(1) process
simdat <- sim_mvgam(
  family = gaussian(),
  n_series = 4,
  trend_model = VAR(cor = TRUE),
  prop_trend = 1
)
plot_mvgam_series(data = simdat$data_train, series = "all")

# Fit a model that uses a latent VAR(1)
mod <- mvgam(
  formula = y ~ -1,
  trend_formula = ~ 1,
  trend_model = VAR(cor = TRUE),
  family = gaussian(),
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

# Plot the autoregressive coefficient distributions;
# use 'dir = "v"' to arrange the order of facets
# correctly
mcmc_plot(
  mod,
  variable = 'A',
  regex = TRUE,
  type = 'hist',
  facet_args = list(dir = 'v')
)

# Calulate forecast error variance decompositions for each series
fevds <- fevd(mod, h = 12)

# Plot median contributions to forecast error variance
plot(fevds)

# View a summary of the error variance decompositions
summary(fevds)
}
}
\references{
Lütkepohl, H. (2007).
New Introduction to Multiple Time Series Analysis. 2nd ed. Springer-Verlag Berlin Heidelberg.
}
\seealso{
\code{\link[=VAR]{VAR()}}, \code{\link[=irf]{irf()}}, \code{\link[=stability]{stability()}}, \code{\link{mvgam_fevd-class}}
}
\author{
Nicholas J Clark
}
