\name{viz.rmvggm}
\alias{viz.rmvggm}
\title{
  Provides summary of sampeles generated from 
  multivariate normal distribution using constrained
  covariance matrix.
 }
\description{
	Generate boxplot of correlation and inverse correlation matrix of generated sample from the "rmvggm" function. Also plots an inferred network using conditional independence test when "net=TRUE". 
}

\usage{
viz.rmvggm(x,col = c("red", "blue"), net = FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
This is a list object returned by
"rmvggm" function.
}
  \item{col}{
  color vector of length 2 for
  coloring boxplots for edge and
  non-edge components
}
 \item{net}{
  is a boolean variable if "TRUE"
  returns a graph object and graph plot.
  The graph is inferred using conditional
  independent test using Grow-Shrink (GS) method.
  For details pleas check "gs" method in "bnlearn"
  package.


}
  \item{\dots}{
    check "gs" function inputs in "bnlearn" package.
}
}
\value{
Returns a list objects chich contains following
objects:

\item{covp}{plot }
\item{covp}{'recordplot' object contains the distribution
of constrained covariance matrix generated by "HTF", "IPF"
or "KIM" algorithm.}
\item{covp}{'recordplot' object contains the distribution
of constrained covariance matrix generated by "HTF", "IPF"
or "KIM" algorithm.}
\item{covsmp}{'recordplot' object contains the distribution
of inverse of covariance of sample matrix.
The samples are generated from multivariate normal distribution
using constrained covariance matrix generated by "HTF", "IPF"
or "KIM" algorithm.}
\item{netp}{'recordplot' object contains networp plot
which is inferred from the samples of multivariate 
normal distribution using constrained covariance matrix 
generated by "HTF", "IPF" or "KIM" algorithm. 
The network is inferred using Grow-Shrink (GS) method.}
\item{infnet}{"igraph" object  of inferred network.}

}
\references{
Margaritis D (2003). Learning Bayesian Network Model 
Structure from Data. Ph.D. thesis, School of 
Computer Science, Carnegie-Mellon University, 
Pittsburgh, PA. 
}
\author{
Shailesh Tripathi, Frank Emmert-Streib
}

\seealso{
gs, bnlearn}
\examples{
  a = barabasi.game(20, directed=FALSE)
  ss <- rmvggm(20, net.str=a, 
    method="htf", cor=.4)
  zz <- viz.rmvggm(ss,net=TRUE, 
    undirected=TRUE, test="cor")

  zz$covp
  zz$covsmp
  zz$netp
}

