% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scipjack.R
\name{scipjack_solver}
\alias{scipjack_solver}
\title{Construct a SCIP-jack solver}
\usage{
scipjack_solver(scipstp_bin, config_file = NULL)
}
\arguments{
\item{scipstp_bin}{path to \verb{scipstp binary}.}

\item{config_file}{scipstp-formatted file. Parameters list is accessible
at  \href{https://www.scipopt.org/doc-6.0.2/html/PARAMETERS.php}{Official SCIP website}.}
}
\description{
This solver requires STP extension of \href{https://scipopt.org/#scipoptsuite}{SCIP-jack} solver.
To use this class you first need to download and build \code{SCIP-jack} and
\code{SCIPSTP} application.
}
\details{
You can access solver directly using \code{run_scip} function. See example.
}
\examples{
\dontrun{
data("bionet_example")
scip <- scipjack_solver(scipstp_bin='/path/to/scipoptsuite/build/bin/applications/scipstp')
sol <- solve_mwcsp(scip, bionet_example)
}
}
\references{
Rehfeldt D., Koch T. (2019)
"Combining NP-Hard Reduction Techniques and Strong Heuristics in an Exact Algorithm for the Maximum-Weight Connected Subgraph Problem."
\doi{10.1137/17M1145963}
}
