/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.graph;

import java.util.ArrayList;
import java.util.List;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.SimpleGraph;

public class SimpleGraphPath<V, E>
implements GraphPath<V, E> {
    private SimpleGraph<V, E> graph;
    private List<V> vertices;
    private List<E> edges;
    private double weight;

    public SimpleGraphPath(SimpleGraph<V, E> simpleGraph, List<V> vertices, double weight2) {
        this.graph = simpleGraph;
        this.vertices = vertices;
        this.edges = new ArrayList();
        this.weight = weight2;
        if (vertices.size() < 2) {
            throw new IllegalArgumentException("At least two vertices are required to form a path");
        }
        for (int i = 0; i < this.getVertexList().size() - 1; ++i) {
            Object currentEdge = ((AbstractBaseGraph)this.getGraph()).getEdge(this.getVertexList().get(i), this.getVertexList().get(i + 1));
            if (currentEdge == null) {
                throw new IllegalArgumentException("The specified vertices do not form a path");
            }
            this.edges.add(currentEdge);
        }
    }

    @Override
    public SimpleGraph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public V getStartVertex() {
        return this.getVertexList().get(0);
    }

    @Override
    public V getEndVertex() {
        return this.getVertexList().get(this.getVertexList().size() - 1);
    }

    @Override
    public List<E> getEdgeList() {
        return this.edges;
    }

    public List<V> getVertexList() {
        return this.vertices;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }
}

