% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lung_FDA}
\alias{lung_FDA}
\title{Multiplex imaging data from a non-small cell lung cancer study}
\format{
\subsection{\code{lung_FDA}}{

An mxFDA object with augmented non-small cel lung cancer multiplex immunofluorescence data, and NN G(r) calculated:
\describe{
\item{Metadata}{information about the spatial samples with column \code{sample_key} column in both}
\item{Spatial}{cell-level information with \code{x} and \code{y} columns along with \code{sample_key} to link to \code{Metadata}}
\item{subject_key}{column in \code{Metadata} that may have multiple \code{sample_key} values for each, akin to patient IDs}
\item{sample_key}{column in both \code{Metadata} and \code{Spatial} that is a 1:1 with the samples (unique per sample)}
\item{univariate_summaries}{univariate summary slot with nearest neighbor G calculared}
\item{bivariate_summaries}{empty slot available for bivariate summaries}
\item{functional_pca}{empty slot for functional PCA data of summaries}
\item{functional_cox}{empty slot for functional models}
}
}
}
\source{
\url{https://bioconductor.org/packages/release/data/experiment/html/VectraPolarisData.html}
}
\usage{
lung_FDA
}
\description{
This data is adapted from the VectraPolarisData Bioconductor package. There are multiple ROIs for each patient.
}
\details{
Spatial summary functions of lung cancer multiplex imaging data.

This data is adapted from the VectraPolarisData Bioconductor package.
Signal between the survival outcome and spatial summary functions has been augmented for teaching purposes.
Spatial relationship is summarized using the nearest neighbor G function.

Includes only spatial samples that had 10 or more radii with calculable G function
}
\keyword{datasets}
