% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myClim-package.R
\docType{package}
\name{myClim-package}
\alias{myClim}
\alias{myClim-package}
\title{myClim: Microclimatic Data Processing}
\description{
Package myClim was designed for microclimate data processing, storing, and analyzing.
The myClim wofrkflow consists of reading logger files, pre-processing the time-series,
time-series aggregation, and microclimatic variables calculation. The microclimatic
data are stored in size-efficient hierarchical structure which respects the
hierarchy of field microclimate measurement (locality>loggers>sensors).

After data import, myClim can summarize the data and automatically correct
for the most common problems.   The myClim package provides functions to
calculate aggregated microclimate statistics as well as methods for data
calibration, conversion and calculation of derived microclimatic variables
like growing degree days, freezing degree days, snow cover duration,
volumetric water content and vapor pressure deficit.

Standardized microclimatic variables can be stored efficiently in myClim
data format or easily exported to standard R long or wide tables for further
analyses and visualization.

\strong{myClim object}

We implemented two slightly different data formats of myClim objects calling them:
Raw-format and Agg-format.
Raw-format is designed for data preparation. Mainly data cleaning,
metadata gathering, time zones handling and multiple downloads joining.
Outputs of functions \code{\link[=mc_read_files]{mc_read_files()}} and \code{\link[=mc_read_data]{mc_read_data()}} are a Raw-format.
Raw-format has the levels of: localities, loggers and sensors.
Function \code{\link[=mc_agg]{mc_agg()}} converts data from Raw-format to Agg-format.
Agg-format is designed mainly for calculations,analysis and microclimatic variables
derivations on the basis of cleaned microclimatic data.
Agg-format is missing the level of loggers. In Agg-format sensors are organized
directly in localities, without loggers.

The highest hierarchical level of myClim structure is the \code{locality}. It has own metadata e.g.
coordinates and elevation. For detail description of locality metadata see \link{mc_LocalityMetadata}.
On the locality in Raw-format there are \code{loggers}; in Agg-format the \code{sensors}.
See below. Loggers represents the files imported with myClim reading functions.
Both \code{loggesr} and \code{sensors} have own metadata. One logger could host more sensors e.g.
Tomst TMS logger hosing TMS_T1 soil temperature, TMS_T2 surface temperature,
TMS_T3 air temperature , TMS_moist soil moisture.
For detailed description of logger and sensor metadata
see \link{mc_LoggerMetadata}, \link{mc_SensorMetadata}, \link{mc_data_sensors}

In Raw-format Within the logger all sensors share time series. In Agg-format where level of
logger is missing, all sensors within the locality share time series. In Raw-format
the time series between the loggers or between the localities can be of different time
step. E.g. on the locality there can be one logger measuring in time step
15 minutes and another one measuring once a day.  In Agg-format this is not allowed.
Therefore it is necessary to use \code{\link[=mc_agg]{mc_agg()}} to switch from Raw-format to the Agg-format.

myClim time step is defined in seconds (\code{data$metadata@step}).
But some steps (especially irregular ones) may not be represented by seconds.
For example step \code{month} has variable number of seconds within the year. Therefore, metadata contains also text
representation of the step (\code{data$metadata@period}).

Schema of myClim \strong{Raw-format}

\preformatted{
            +-------------------------+
$metadata   | mc_MainMetadata - class |
            +-------------------------+
            | @version                |
            | @format_type            |
            +-------------------------+
            +-------------------------------------------------------------------------------+
$localities | locality[1]                                                                   |
            +-------------------------------------------------------------------------------+
            |           +-----------------------------+                                     |
            | $metadata | mc_LocalityMetadata - class |                                     |
            |           +-----------------------------+                                     |
            |           | @locality_id                |                                     |
            |           | @elevation                  |                                     |
            |           | @lat_wgs84                  |                                     |
            |           | @lon_wgs84                  |                                     |
            |           | @tz_offset                  |                                     |
            |           | @tz_type                    |                                     |
            |           | @join_serial                |                                     |
            |           | @user_data                  |                                     |
            |           +-----------------------------+                                     |
            |           +------------------------------------------------------------------+|
            | $loggers  | logger[1]                                                        ||
            |           +------------------------------------------------------------------+|
            |           |             +---------------------------+                        ||
            |           | $metadata   | mc_LoggerMetadata - class |                        ||
            |           |             +---------------------------+                        ||
            |           |             | @type                     |                        ||
            |           |             | @name                     |                        ||
            |           |             | @serial_number            |                        ||
            |           |             | @step                     |                        ||
            |           |             +---------------------------+                        ||
            |           |             +----------------------------+                       ||
            |           | $clean_info | mc_LoggerCleanInfo - class |                       ||
            |           |             +----------------------------+                       ||
            |           |             | @step                      |                       ||
            |           |             | @count_duplicities         |                       ||
            |           |             | @count_missing             |                       ||
            |           |             | @count_disordered          |                       ||
            |           |             | @rounded                   |                       ||
            |           |             +----------------------------+                       ||
            |           | $datetime   POSIXct vector                                       ||
            |           |             +---------------------------------------------------+||
            |           | $sensors    | sensor[1]                                         |||
            |           |             +---------------------------------------------------+||
            |           |             |              +---------------------------+        |||
            |           |             | $metadata    | mc_SensorMetadata - class |        |||
            |           |             |              +---------------------------+        |||
            |           |             |              | @sensor_id                |        |||
            |           |             |              | @name                     |        |||
            |           |             |              | @height                   |        |||
            |           |             |              | @calibrated               |        |||
            |           |             |              +---------------------------+        |||
            |           |             | $values      numeric/logical vector               |||
            |           |             |              +----------+------------+-----------+|||
            |           |             | $calibration | datetime | cor_factor | cor_slope ||||
            |           |             |              | ...      | ...        | ...       ||||
            |           |             |              +----------+------------+-----------+|||
            |           |             |              +-----+-------+-----+-------+        |||
            |           |             | $states      | tag | start | end | value |        |||
            |           |             |              | ... | ...   | ... | ...   |        |||
            |           |             |              +-----+-------+-----+-------+        |||
            |           |             +---------------------------------------------------+||
            |           |             +---------------------------------------------------+||
            |           |             | sensor[2]                                         |||
            |           |             +---------------------------------------------------+||
            |           |             ...                                                  ||
            |           |             +---------------------------------------------------+||
            |           |             | sensor[n]                                         |||
            |           |             +---------------------------------------------------+||
            |           +------------------------------------------------------------------+|
            |           +------------------------------------------------------------------+|
            |           | logger[2]                                                        ||
            |           +------------------------------------------------------------------+|
            |           ...                                                                 |
            |           +------------------------------------------------------------------+|
            |           | logger[n]                                                        ||
            |           +------------------------------------------------------------------+|
            +-------------------------------------------------------------------------------+
            +-------------------------------------------------------------------------------+
            | locality[2]                                                                   |
            +-------------------------------------------------------------------------------+
            ...
            +-------------------------------------------------------------------------------+
            | locality[n]                                                                   |
            +-------------------------------------------------------------------------------+}

Agg-format is the output of \code{\link[=mc_agg]{mc_agg()}} function.
Agg-format is mainly designed for calculations which are faster in Agg and slower in Raw.

Schema of myClim \strong{Agg-format}

\preformatted{
            +----------------------------+
$metadata   | mc_MainMetadataAgg - class |
            +----------------------------+
            | @version                   |
            | @format_type               |
            | @step                      |
            | @period                    |
            | @intervals_start           |
            | @intervals_end             |
            +----------------------------+
            +-----------------------------------------------------------------+
$localities | locality[1]                                                     |
            +-----------------------------------------------------------------+
            |            +-----------------------------+                      |
            | $metadata  | mc_LocalityMetadata - class |                      |
            |            +-----------------------------+                      |
            |            | @locality_id                |                      |
            |            | @elevation                  |                      |
            |            | @lat_wgs84                  |                      |
            |            | @lon_wgs84                  |                      |
            |            | @tz_offset                  |                      |
            |            | @tz_type                    |                      |
            |            | @join_serial                |                      |
            |            | @user_data                  |                      |
            |            +-----------------------------+                      |
            | $datetime  POSIXct vector                                       |
            |            +---------------------------------------------------+|
            | $sensors   | sensor[1]                                         ||
            |            +---------------------------------------------------+|
            |            |              +---------------------------+        ||
            |            | $metadata    | mc_SensorMetadata - class |        ||
            |            |              +---------------------------+        ||
            |            |              | @sensor_id                |        ||
            |            |              | @name                     |        ||
            |            |              | @height                   |        ||
            |            |              | @calibrated               |        ||
            |            |              +---------------------------+        ||
            |            | $values      numeric/logical vector               ||
            |            |              +----------+------------+-----------+||
            |            | $calibration | datetime | cor_factor | cor_slope |||
            |            |              | ...      | ...        | ...       |||
            |            |              +----------+------------+-----------+||
            |            |              +-----+-------+-----+-------+        ||
            |            | $states      | tag | start | end | value |        ||
            |            |              | ... | ...   | ... | ...   |        ||
            |            |              +-----+-------+-----+-------+        ||
            |            +---------------------------------------------------+|
            |            +---------------------------------------------------+|
            |            | sensor[2]                                         ||
            |            +---------------------------------------------------+|
            |            ...                                                  |
            |            +---------------------------------------------------+|
            |            | sensor[n]                                         ||
            |            +---------------------------------------------------+|
            +-----------------------------------------------------------------+
            +-----------------------------------------------------------------+
            | locality[2]                                                     |
            +-----------------------------------------------------------------+
            ...
            +-----------------------------------------------------------------+
            | locality[n]                                                     |
            +-----------------------------------------------------------------+}
}
\seealso{
Useful links:
\itemize{
  \item \url{http://labgis.ibot.cas.cz/myclim/index.html}
  \item \url{https://github.com/ibot-geoecology/myClim}
}

}
\author{
\strong{Maintainer}: Vojtěch Kalčík \email{Vojtech.Kalcik@ibot.cas.cz}

Authors:
\itemize{
  \item Matěj Man \email{Matej.Man@ibot.cas.cz}
  \item Martin Macek \email{Martin.Macek@ibot.cas.cz}
  \item Josef Brůna \email{Josef.Bruna@ibot.cas.cz}
  \item Lucia Hederová \email{Lucia.Hederova@ibot.cas.cz}
  \item Jan Wild \email{Jan.Wild@ibot.cas.cz}
  \item Martin Kopecký \email{Martin.Kopecky@ibot.cas.cz}
}

Other contributors:
\itemize{
  \item Institute of Botany of the Czech Academy of Sciences [copyright holder]
}

}
\keyword{internal}
