% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_txi_sc}
\alias{cpp_txi_sc}
\title{Calculate TXI for Single-Cell Expression Data (C++ Implementation)}
\usage{
cpp_txi_sc(expression, strata_values, batch_size = 2000L, ncores = 10L)
}
\arguments{
\item{expression}{Sparse expression matrix (genes x cells) - dgCMatrix format}

\item{strata_values}{Numeric vector of phylostratum values for each gene}

\item{batch_size}{Integer, number of cells to process per batch (default: 2000)}

\item{ncores}{Integer, number of cores to use for parallel processing (default: 10, automatically capped at available cores)}
}
\value{
Numeric vector of TXI values for each cell
}
\description{
Efficiently calculate TXI values for sparse single-cell expression matrices
using batch processing and parallel computation.
}
\details{
This function processes large sparse single-cell expression matrices efficiently by:
- Splitting cells into batches to manage memory usage
- Using parallel processing across batches
- Leveraging sparse matrix operations to skip zero entries
- Handling cells with zero expression by returning NA
}
\author{
Kristian K Ullrich
}
\keyword{internal}
