% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce_safe.R
\name{coerce_safe}
\alias{coerce_safe}
\title{coerce_safe}
\usage{
coerce_safe(object, class, alert = stop, ..., alert_irreversible = alert,
  alert_na = alert)
}
\arguments{
\item{object}{to be coerced}

\item{class}{character; class to which \code{object} should be coerced.}

\item{alert}{function to use to raise exceptions: (Default: \code{\link[base:stop]{base::stop()}})}

\item{...}{unused}

\item{alert_irreversible}{function to raise alert when coercion is not
reversible. See Details.}

\item{alert_na}{function to raise when \code{NAs} are produced.

\code{coerce_safe} transform the \code{object} to \code{class} in a safe, consistent,
non-destructive way.

Safe means that coercison:
\enumerate{
\item is non-destructive (i.e information is not lost in the transformation )
\item is reversible: \deqn{ f^{-1}( f(x) ) == x }
\item does not introduce (additional) missing values (\code{NA})
}

By default, \code{corece_safe} raises an alert (message|warning|error)
when the attempted coercion violates these constraints.  The \code{alert}
argument (and \code{alert_irreversible} or \code{alert_na}) can be used
to fleixble change the response.  Valid values for these are
\code{\link[base:message]{base::message()}}, \code{\link[base:warning]{base::warning()}} and \link[base:stop]{base::stop} among others.}
}
\value{
\code{object} coerced to \code{class} but ensured that there has been no loss in data
and no additional Missonve values introduced.
}
\description{
Coerce values in a safe, non-destructive and consistent way.
}
\note{
There must be a \code{as} method to the reverse coercion for this function to work.
}
\examples{

\dontrun{
  # Error
  coerce_safe(1.01, "integer")  # 1.01 != 1
  coerce_safe( c("1","2","a"), "integer" )
}

}
\seealso{
\link[methods:as]{methods::as}
`coercion::try_as()``
}
