% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast-shadows.R
\name{cast_shadow_shift_label}
\alias{cast_shadow_shift_label}
\title{Add a shadow column and a shadow shifted column to a dataset}
\usage{
cast_shadow_shift_label(data, ...)
}
\arguments{
\item{data}{data.frame}

\item{...}{One or more unquoted expressions separated by commas. These also
respect the dplyr verbs "starts_with", "contains", "ends_with", etc.}
}
\value{
data.frame with the shadow and shadow_shift vars, and missing labels
}
\description{
Shift the values, add shadow, add missing label
}
\examples{

airquality \%>\% cast_shadow_shift_label(Ozone)
airquality \%>\% cast_shadow_shift_label(Ozone, Solar.R)

# replicate the plot generated by geom_miss_point()

library(ggplot2)

airquality \%>\%
  cast_shadow_shift_label(Ozone,Solar.R) \%>\%
  ggplot(aes(x = Ozone_shift,
             y = Solar.R_shift,
             colour = any_missing)) +
        geom_point()

}
