% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-case.R
\name{gg_miss_case}
\alias{gg_miss_case}
\title{Plot the number of missings per case (row)}
\usage{
gg_miss_case(x, facet, order_cases = TRUE, show_pct = FALSE)
}
\arguments{
\item{x}{data.frame}

\item{facet}{(optional) a single bare variable name, if you want to create a faceted plot.}

\item{order_cases}{logical Order the rows by missingness (default is FALSE -
no order).}

\item{show_pct}{logical Show the percentage of cases}
}
\value{
a ggplot object depicting the number of missings in a given case.
}
\description{
This is a visual analogue to \code{miss_case_summary}. It draws a ggplot of the
number of missings in each case (row). A default minimal theme is used, which
can be customised as normal for ggplot.
}
\examples{

gg_miss_case(airquality)
library(ggplot2)
gg_miss_case(airquality) + labs(x = "Number of Cases")
gg_miss_case(airquality, show_pct = TRUE)
gg_miss_case(airquality, order_cases = FALSE)
gg_miss_case(airquality, facet = Month)
gg_miss_case(airquality, facet = Month, order_cases = FALSE)
gg_miss_case(airquality, facet = Month, show_pct = TRUE)

}
\seealso{
\code{\link[=geom_miss_point]{geom_miss_point()}} \link{gg_miss_case_cumsum} \code{\link[=gg_miss_fct]{gg_miss_fct()}} \code{\link[=gg_miss_span]{gg_miss_span()}} \code{\link[=gg_miss_var]{gg_miss_var()}} \code{\link[=gg_miss_var_cumsum]{gg_miss_var_cumsum()}} \code{\link[=gg_miss_which]{gg_miss_which()}}
}
