% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-prop-pct-summary.R
\name{miss_prop_summary}
\alias{miss_prop_summary}
\title{Proportions of missings in data, variables, and cases.}
\usage{
miss_prop_summary(data)
}
\arguments{
\item{data}{a dataframe}
}
\value{
a dataframe
}
\description{
Return missing data info about the dataframe, the variables, and the cases.
Specifically, returning how many elements in a dataframe contain a missing
value, how many elements in a variable contain a missing value, and how many
elements in a case contain a missing.
}
\examples{

miss_prop_summary(airquality)
library(dplyr)
airquality \%>\% group_by(Month) \%>\% miss_prop_summary()

}
\seealso{
\code{\link[=pct_miss_case]{pct_miss_case()}} \code{\link[=prop_miss_case]{prop_miss_case()}} \code{\link[=pct_miss_var]{pct_miss_var()}} \code{\link[=prop_miss_var]{prop_miss_var()}} \code{\link[=pct_complete_case]{pct_complete_case()}} \code{\link[=prop_complete_case]{prop_complete_case()}} \code{\link[=pct_complete_var]{pct_complete_var()}} \code{\link[=prop_complete_var]{prop_complete_var()}} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \code{\link[=miss_case_summary]{miss_case_summary()}} \code{\link[=miss_case_table]{miss_case_table()}} \code{\link[=miss_summary]{miss_summary()}} \code{\link[=miss_var_run]{miss_var_run()}} \code{\link[=miss_var_span]{miss_var_span()}} \code{\link[=miss_var_summary]{miss_var_summary()}} \code{\link[=miss_var_table]{miss_var_table()}}
}
