% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-recode.R
\name{shadow_expand_relevel}
\alias{shadow_expand_relevel}
\title{Expand and relevel a shadow column with a new suffix}
\usage{
shadow_expand_relevel(.var, suffix)
}
\arguments{
\item{.var}{a variable in a data.frame}

\item{suffix}{a character suffix to add to NA_, e.}
}
\value{
a factor with expanded levels
}
\description{
Internal function to handle appropriate expansion and releveling of
shadow variables.
}
\examples{
df <- tibble::tribble(
  ~wind, ~temp,
  -99,    45,
  68,    NA,
  72,    25
)

dfs <- bind_shadow(df)

test_shade <- dfs$wind_NA

#  shadow_expand_relevel(test_shade, "weee")

#  dfs \%>\%
#    mutate(temp_NA = shadow_expand_relevel(temp_NA, "weee"))


# test that this breaks
# shadow_expand_relevel(airquality, "weee")
}
