% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{pipe_notify}
\alias{pipe_notify}
\title{Pipe Notify}
\usage{
pipe_notify(socket, cv, cv2 = NULL, add = FALSE, remove = FALSE, flag = FALSE)
}
\arguments{
\item{socket}{a Socket.}

\item{cv}{a 'conditionVariable' to signal.}

\item{cv2}{[default NULL] optionally, if specified, a second
'conditionVariable' to signal. Note that this cv is signalled
sequentially after the first condition variable.}

\item{add}{[default FALSE] logical value whether to signal when a pipe is
added.}

\item{remove}{[default FALSE] logical value whether to signal when a pipe is
removed.}

\item{flag}{[default FALSE] logical value whether to also set a flag in the
'conditionVariable'. This can help distinguish between different types of
signal, and causes any subsequent \code{\link{wait}} to return FALSE
instead of TRUE. If a signal from the \pkg{tools} package, e.g.
\code{tools::SIGINT}, or an equivalent integer value is supplied, this
sets a flag and additionally raises this signal upon the flag being set.}
}
\value{
Invisibly, zero on success (will otherwise error).
}
\description{
Signals a 'conditionVariable' whenever pipes (individual connections) are
    added or removed at a socket.
}
\details{
For add: this event occurs after the pipe is fully added to the
    socket. Prior to this time, it is not possible to communicate over the
    pipe with the socket.

    For remove: this event occurs after the pipe has been removed from the
    socket. The underlying transport may be closed at this point, and it is
    not possible to communicate using this pipe.
}
\examples{
s <- socket(listen = "inproc://nanopipe")
cv <- cv()
cv2 <- cv()

pipe_notify(s, cv, cv2, add = TRUE, remove = TRUE, flag = TRUE)
cv_value(cv)
cv_value(cv2)

s1 <- socket(dial = "inproc://nanopipe")
cv_value(cv)
cv_value(cv2)
close(s1)
cv_value(cv)
cv_value(cv2)

(wait(cv))
(wait(cv2))

close(s)

}
