% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sha.R
\name{sha224}
\alias{sha224}
\title{Cryptographic Hashing Using the SHA-224 Algorithm}
\usage{
sha224(x, key = NULL)
}
\arguments{
\item{x}{an object.}

\item{key}{(optional) supply a secret key to generate an HMAC. If missing or
NULL, the SHA-224 hash of 'x' is returned.}
}
\value{
A 'nanoHash' object - raw vector of length 28.
}
\description{
Returns a SHA-224 hash or HMAC of the supplied R object. Uses the optimised
    implementation from the Mbed TLS library.
}
\details{
For arguments 'x' and 'key', a raw vector is hashed directly, a
    character string is converted using \code{\link{charToRaw}}, whilst other
    objects are serialised first.

    Use \code{as.character()} to convert the returned raw vector to a single
    character string.
}
\examples{
sha224("hello world!")

# Converts to a character string:
as.character(sha224("hello world!"))

# Obtain HMAC:
sha224("hello world!", "SECRET_KEY")

}
