% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{parse_url}
\alias{parse_url}
\title{Parse URL}
\usage{
parse_url(url)
}
\arguments{
\item{url}{character string containing a URL.}
}
\value{
A named character vector of length 10, comprising: \itemize{
    \item{\code{rawurl}} {- the unparsed URL string.}
    \item{\code{scheme}} {- the URL scheme, such as "http" or "inproc"
    (always lower case).}
    \item{\code{userinfo}} {- the username and password if supplied in the
    URL string.}
    \item{\code{host}} {- the full host part of the URL, including the port
    if present (separated by a colon).}
    \item{\code{hostname}} {- the name of the host.}
    \item{\code{port}} {- the port (if not specified, the default port if
    defined by the scheme).}
    \item{\code{path}} {- the path, typically used with HTTP or WebSocket.}
    \item{\code{query}} {- the query info (typically following ? in the URL).}
    \item{\code{fragment}} {- used for specifying an anchor, the part after #
    in a URL.}
    \item{\code{requri}} {- the full Request-URI (path[?query][#fragment]).}
    }
    Values that cannot be determined are represented by an empty string \code{''}.
}
\description{
Parses a character string containing an RFC 3986 compliant URL as per NNG.
}
\examples{
parse_url("https://user:password@w3.org:8080/type/path?q=info#intro")
parse_url("tcp://192.168.0.2:5555")

}
