% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{reply}
\alias{reply}
\title{Reply over Context (RPC Server for Req/Rep Protocol)}
\usage{
reply(
  context,
  execute,
  recv_mode = c("serial", "character", "complex", "double", "integer", "logical",
    "numeric", "raw"),
  send_mode = c("serial", "raw"),
  timeout = NULL,
  ...
)
}
\arguments{
\item{context}{a Context.}

\item{execute}{a function which takes the received (converted) data as its
first argument. Can be an anonymous function of the form
\code{function(x) do(x)}. Additional arguments can also be passed in
through \sQuote{...}.}

\item{recv_mode}{[default 'serial'] character value or integer equivalent -
one of \sQuote{serial} (1L), \sQuote{character} (2L), \sQuote{complex}
(3L), \sQuote{double} (4L), \sQuote{integer} (5L), \sQuote{logical} (6L),
\sQuote{numeric} (7L), \sQuote{raw} (8L), or \sQuote{string} (9L). The
default \sQuote{serial} means a serialised R object; for the other
modes, received bytes are converted into the respective mode.
\sQuote{string} is a faster option for length one character vectors.}

\item{send_mode}{[default 'serial'] character value or integer equivalent -
either \sQuote{serial} (1L) to send serialised R objects, or \sQuote{raw}
(2L) to send atomic vectors of any type as a raw byte vector.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout. Note
that this applies to receiving the request. The total elapsed time would
also include performing 'execute' on the received data. The timeout then
also applies to sending the result (in the event that the requestor has
become unavailable since sending the request).}

\item{...}{additional arguments passed to the function specified by 'execute'.}
}
\value{
Integer exit code (zero on success).
}
\description{
Implements an executor/server for the rep node of the req/rep protocol.
    Awaits data, applies an arbitrary specified function, and returns the
    result to the caller/client.
}
\details{
Receive will block while awaiting a message to arrive and is usually
    the desired behaviour. Set a timeout to allow the function to return
    if no data is forthcoming.

    In the event of an error in either processing the messages or in
    evaluation of the function with respect to the data, a nul byte \code{00}
    (or serialized nul byte) will be sent in reply to the client to signal an
    error. This is to be distinguishable from a possible return value.
    \code{\link{is_nul_byte}} can be used to test for a nul byte.
}
\section{Send Modes}{


    The default mode \sQuote{serial} sends serialised R objects to ensure
    perfect reproducibility within R. When receiving, the corresponding mode
    \sQuote{serial} should be used. Custom serialization and unserialization
    functions for reference objects may be enabled by the function
    \code{\link{next_config}}.

    Mode \sQuote{raw} sends atomic vectors of any type as a raw byte vector,
    and must be used when interfacing with external applications or raw
    system sockets, where R serialization is not in use. When receiving, the
    mode corresponding to the vector sent should be used.
}

\examples{
req <- socket("req", listen = "tcp://127.0.0.1:6546")
rep <- socket("rep", dial = "tcp://127.0.0.1:6546")

ctxq <- context(req)
ctxp <- context(rep)

send(ctxq, 2022, block = 100)
reply(ctxp, execute = function(x) x + 1, send_mode = "raw", timeout = 100)
recv(ctxq, mode = "double", block = 100)

send(ctxq, 100, mode = "raw", block = 100)
reply(ctxp, recv_mode = "double", execute = log, base = 10, timeout = 100)
recv(ctxq, block = 100)

close(req)
close(rep)

}
