% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanotime.R
\name{nanotime}
\alias{nanotime}
\alias{nanotime.default}
\alias{nanotime.numeric}
\alias{nanotime.character}
\alias{nanotime.matrix}
\alias{nanotime.POSIXct}
\alias{nanotime.POSIXlt}
\alias{nanotime.Date}
\alias{print.nanotime}
\alias{format.nanotime}
\alias{index2char.nanotime}
\alias{as.POSIXct.nanotime}
\alias{as.POSIXlt.nanotime}
\alias{as.Date.nanotime}
\alias{as.data.frame.nanotime}
\alias{as.integer64.nanotime}
\alias{Ops.nanotime}
\alias{as.integer64}
\title{Nanosecond resolution datetime functionality}
\usage{
nanotime(x)

\method{nanotime}{default}(x)

\method{nanotime}{numeric}(x)

\method{nanotime}{character}(x)

\method{nanotime}{matrix}(x)

\method{nanotime}{POSIXct}(x)

\method{nanotime}{POSIXlt}(x)

\method{nanotime}{Date}(x)

\method{print}{nanotime}(x, ...)

\method{format}{nanotime}(x, justify = "right", digits = NULL,
  na.encode = FALSE, trim = TRUE, ...)

\method{index2char}{nanotime}(x, frequency = NULL, ...)

\method{as.POSIXct}{nanotime}(x, tz, ...)

\method{as.POSIXlt}{nanotime}(x, tz, ...)

\method{as.Date}{nanotime}(x, ...)

\method{as.data.frame}{nanotime}(x, ...)

\method{as.integer64}{nanotime}(x, ...)

\method{Ops}{nanotime}(e1, e2)

as.integer64(x, ...)
}
\arguments{
\item{x}{The object which want to convert to class \code{nanotime}}

\item{...}{Required for print method signature but ignored here}

\item{justify}{Required for \code{format} method but ignored here}

\item{digits}{Required for  \code{format} method but ignored here}

\item{na.encode}{Required for  \code{format} method but ignored here}

\item{trim}{Required for  \code{format} method but ignored here}

\item{frequency}{Required for \code{index2char} method but ignored here}

\item{tz}{Required for \code{as.POSIXct} and \code{as.POSIXlt},
can be set via \code{options("nanotimeFormat")} and uses \sQuote{UTC} as
a default and fallback}

\item{e1}{Operand of class \code{nanotime}}

\item{e2}{Operand of class \code{nanotime}}
}
\value{
A nanotime object
}
\description{
Functions to operate on nanosecond time resolution using integer64
bit representation. Conversions functions for several standard R
types are provided, and more will be added as needed.

\code{as.integer64} conversion helper returning the underlying
\code{integer64} representation
}
\details{
Notice that the conversion from POSIXct explicitly sets the last
three digits to zero. Nanosecond time stored in a 64-bit integer
has nineteen digits precision where doubles (which are used
internally for POSIXct as well) only have sixteen digits.  So
rather than showing three more (essentially \emph{random}) digits
it is constructed such that these three additional digits are
zeros.
}
\section{Caveats}{


Working with dates and times is \emph{difficult}. One
needs a representation of both \emph{time points} and
\emph{time duration}. In R, think of \code{Date} or
\code{POSIXct} objects for the former, and \code{difftime}
for the later. Here we (currently) only have time points,
but they are effectively also durations relative to the
epoch of January 1, 1970.
}

\section{Design}{


There are two external libraries doing two key components.

We rely on the \code{\link{bit64}} package for \code{integer64}
types to represent nanoseconds relative to the epoch.  This is
similar to \code{POSIXct} which uses fractional seconds since the
epoch---so here we are essentially having the same values, but
multiplied by 10 to the power 9 and stored as integers.  We need
to rely on the external package as we require 64-bit integers
whereas R itself only has 32-bit integers.  The
\code{\link{bit64}} package is clever about how it manages to
provide such an integer using only the 64-bit double type and very
clever (and efficient) transformations.

The other is the CCTZ library in C++, which we access via the
\code{\link{RcppCCTZ}} package. CCTZ extends the C++11 standard
library type \code{chrono} type in very useful ways for time zones and
localtime.  We use its formating and parsing features.
}

\section{Output Format}{


Formatting and character conversion for \code{nanotime} objects is
done by functions from the \code{\link{RcppCCTZ}} package relying
on code from its embedded \code{CCTZ} library. The default format
is ISO3339 compliant: \code{\%Y-\%m-\%dT\%H:\%M:\%E9S\%Ez}. It
specifies a standard ISO 8601 part for date and time --- as well
as nine digits of precision for fractional seconds (down to
nanoseconds) and on offset (typically zero as we default to UTC).
It can be overriden by using \code{options()} with the key of
\code{nanotimeFormat} and a suitable value. Similarly,
\code{nanotimeTz} can be used to select a different timezone.
}

\examples{
x <- nanotime("1970-01-01T00:00:00.000000001+00:00")
print(x)
x <- x + 1
print(x)
format(x)
x <- x + 10
print(x)
format(x)
format(nanotime(Sys.time()) + 1:3)  # three elements each 1 ns apart
}
\author{
Dirk Eddelbuettel
}
