% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoival.R
\name{intersect,nanoival,nanoival-method}
\alias{intersect,nanoival,nanoival-method}
\alias{union,nanoival,nanoival-method}
\alias{setdiff,nanoival,nanoival-method}
\alias{intersect.idx,nanotime,nanoival-method}
\alias{intersect.idx}
\alias{\%in\%.nanotime}
\alias{intersect,nanotime,nanoival-method}
\alias{setdiff,nanotime,nanoival-method}
\alias{setdiff.idx,nanotime,nanoival-method}
\alias{setdiff.idx}
\alias{intersect,nanotime,nanotime-method}
\alias{union,nanotime,nanotime-method}
\alias{setdiff,nanotime,nanotime-method}
\title{Set operations}
\usage{
\S4method{intersect}{nanoival,nanoival}(x, y)

\S4method{union}{nanoival,nanoival}(x, y)

\S4method{setdiff}{nanoival,nanoival}(x, y)

\S4method{intersect.idx}{nanotime,nanoival}(x, y)

\method{\%in\%}{nanotime}(x, table)

\S4method{intersect}{nanotime,nanoival}(x, y)

\S4method{setdiff}{nanotime,nanoival}(x, y)

\S4method{setdiff.idx}{nanotime,nanoival}(x, y)

\S4method{intersect}{nanotime,nanotime}(x, y)

\S4method{union}{nanotime,nanotime}(x, y)

\S4method{setdiff}{nanotime,nanotime}(x, y)
}
\arguments{
\item{x, y}{a temporal type}

\item{table}{\code{nanoival}: used in \code{\%in\%}}
}
\value{
\code{intersect}, \code{union}, \code{setdiff} return
    temporal types that are the result of the intersection. For
    instance, set operations on two \code{nanoival} return a
    \code{nanoival}, whereas intersection between a
    \code{nanoival} and a \code{nanotime} returns a
    \code{nanotime}. \code{intersect.idx} return a list of vectors
    representing the element indices that intersect and
    \code{setdiff.idx} returns a vector representing the element
    indices to be removed.
}
\description{
Performs set intersection, union and difference between vectors of
temporal types from the \code{nanotime} package.
}
\details{
Set operations between \code{nanoival} operands allow the
construction of complex interval vectors (i.e. a \code{nanoival}
vector can specify any number of inclusions and exclusions of
time). Set operations between \code{nanotime} and \code{nanoival}
allow to subset time vectors with interval vectors. In addition to
the generic set functions, the function \code{intersect.idx} is
defined which returns the indices of the intersection, and the
operator \code{\%in\%} is overloaded for \code{nanotime-nanoival}
which returns a logical vector that indicates which elements
belong to the interval vector.
}
\examples{
## a vector of 'nanotime' can be subsetted by a 'nanoival' which is equivalent to 'intersect':
one_second <- 1e9
a <- seq(nanotime("2012-12-12 12:12:12+00:00"), length.out=10, by=one_second)
idx <- c(as.nanoival("-2012-12-12 12:12:10+00:00 -> 2012-12-12 12:12:14+00:00-"),
         as.nanoival("+2012-12-12 12:12:18+00:00 -> 2012-12-12 12:12:20+00:00+"))
a[idx]
intersect(a, idx)

## 'nanoival' also has the set operations 'union', 'intersect', 'setdiff':
a <- seq(nanotime("2012-12-12 12:12:12+00:00"), length.out=10, by=one_second)
i <- as.nanoival("-2012-12-12 12:12:14+00:00 -> 2012-12-12 12:12:18+00:00-")
setdiff(a, i)

i1 <- as.nanoival("+2012-12-12 12:12:14+00:00 -> 2012-12-12 12:12:17+00:00-")
i2 <- as.nanoival("+2012-12-12 12:12:16+00:00 -> 2012-12-12 12:12:18+00:00-")
union(i1, i2)

## 'intersect.idx' returns the indices of the intersection:
a <- seq(nanotime("2012-12-12 12:12:12+00:00"), length.out=10, by=one_second)
idx <- as.nanoival("+2012-12-12 12:12:14+00:00 -> 2012-12-12 12:12:19+00:00+")
idx_intersect <- intersect.idx(a, idx)

## Intersection can be performed using these indices:
a[idx_intersect$x]

## which is equivalent to:
a[idx]

## The logical vector indicating intersection can be obtained like this:
a \%in\% idx

}
