% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naptime.R
\docType{methods}
\name{naptime}
\alias{naptime}
\alias{naptime,NULL-method}
\alias{naptime,POSIXct-method}
\alias{naptime,Period-method}
\alias{naptime,character-method}
\alias{naptime,difftime-method}
\alias{naptime,logical-method}
\alias{naptime,numeric-method}
\title{Safe sleep function}
\usage{
naptime(time)

\S4method{naptime}{numeric}(time)

\S4method{naptime}{Period}(time)

\S4method{naptime}{POSIXct}(time)

\S4method{naptime}{difftime}(time)

\S4method{naptime}{logical}(time)

\S4method{naptime}{`NULL`}(time)

\S4method{naptime}{character}(time)
}
\arguments{
\item{time}{Time to sleep, polymorphic type inputs, leaning towards units as 'seconds'}
}
\value{
NULL; A side effect of a pause in program execution
}
\description{
Acceptable inputs:
\itemize{
 \item numeric: time in seconds to nap
 \item NULL: nap for default duration
 \item POSIXct: time at which the nap should stop  (timezone is respected)
 \item Period: time from now at which the nap should stop
 \item character: yyyy-mm-dd hh:mm:ss at which nap should stop, time zone is assumed to be Sys.timezone() and hh:mm:ss is optional as three formats may be missing, cf. lubridate::ymd_hms().
 \item difftime: difference in time to nap
 \item logical: nap for default duration
 \item generic: nap for default duration
}
}
\examples{
\dontrun{
naptime(1)
naptime(difftime("2016-01-01 00:00:01", "2016-01-01 00:00:00"))
}
}

