% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-xform.R
\name{fit_xform}
\alias{fit_xform}
\title{Fit affine or thin plate spline transform to arbitrary transformation}
\usage{
fit_xform(
  reg,
  samplepts,
  refpts = NULL,
  type = c("affine", "rigid", "similarity", "tps"),
  subsample = FALSE,
  scale = c(1, 1),
  ...
)
}
\arguments{
\item{reg}{Any registration compatible with \code{nat::\link{xform}},
including non-rigid and multi-step registrations. You must either supply
this or the \code{refpts} argument.}

\item{samplepts}{A set of points in the sample (floating) space. Can be any
object compatible with \code{nat::\link{xyzmatrix}}.}

\item{refpts}{An optional set of points in the target (fixed) space matching
\code{samplepts}. You must either supply this or the \code{reg} argument.}

\item{type}{A character string specifying the type of registration. See
\code{\link{computeTransform}} for details.}

\item{subsample}{A number of points to subsample from
\code{samplepts,refpts}. The default value of \code{FALSE} means use all
provided points to calculate the new transform.}

\item{scale}{a 2-vector indicating the amount to scale the sample and
reference points. You can supply one vector if this is the same. If the
transform expects points in microns and returns points in microns then you
would need \code{scale=c(1000,1)} if you want the input to be in microns
and the output to be in nm.}

\item{...}{Additional arguments passed to \code{\link{computeTransform}}}
}
\value{
A homogeneous affine matrix or a \code{nat::tpsreg} object
  n.b. only in development nat (>= 1.10.1)
}
\description{
Fit affine or thin plate spline transform to arbitrary transformation
}
\examples{
\dontrun{
library(nat.flybrains)
reg=shortest_bridging_seq(sample='FCWB', reference="JFRC2")
fit_xform(reg, nat::kcs20, subsample=200, type='affine')
# compute transform with translations in nm not microns
fit_xform(reg, nat::kcs20, subsample=200, type='affine', scale=1000)
}
}
