% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/cmtk-reformat.R
\name{cmtk.statistics}
\alias{cmtk.statistics}
\title{Calculate image statistics for a nrrd or other CMTK compatible file}
\usage{
cmtk.statistics(f, mask, masktype = c("label", "binary"), ...,
  Verbose = FALSE)
}
\arguments{
  \item{f}{Path to image file (any CMTK compatible format)}

  \item{mask}{Optional path to a mask file}

  \item{masktype}{Whether mask should be treated as label
  field or binary mask (default label)}

  \item{...}{Additional arguments for ctmk's statistics
  tool processed by \code{\link{cmtk.call}}.}

  \item{Verbose}{Whether to show cmtk status messages and
  be verbose about file update checks. Sets command line
  \code{--verbose} option.}
}
\value{
return dataframe describing results
}
\description{
Calculate image statistics for a nrrd or other CMTK
compatible file
}
\details{
When given a label mask returns a dataframe with a row for
each level of the label field. If GJ's modified version of
CMTK statistics is available this will include an extra
column with the number of non-zero voxels in the main image
for each level of the mask.
}
\examples{
\dontrun{
cmtk.statistics('someneuron.nrrd',mask='neuropilregionmask.nrrd')
}
}

