% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuronlistfh.R
\name{remotesync}
\alias{remotesync}
\alias{remotesync.neuronlistfh}
\title{Synchronise a remote object}
\usage{
remotesync(x, remote = attr(x, "remote"), download.missing = TRUE,
  delete.extra = FALSE, ...)

\method{remotesync}{neuronlistfh}(x, remote = attr(x, "remote"),
  download.missing = FALSE, delete.extra = FALSE, indices = NULL,
  update.object = TRUE, ...)
}
\arguments{
\item{x}{Object to synchronise with a remote URL}

\item{remote}{The remote URL to update from}

\item{download.missing}{Whether to download missing objects (default TRUE)}

\item{delete.extra}{Whether to delete objects (default TRUE)}

\item{\dots}{Additional arguments passed to methods}

\item{indices}{Character vector naming neurons to update (default
\code{indices=NULL} implies all neurons).}

\item{update.object}{Whether to update the \code{neuronlistfh} object itself 
on disk (default TRUE). Note that this assumes that the \code{neuronlistfh}
object has not been renamed after it was downloaded.}
}
\value{
The updated \code{neuronlistfh} object (invisibly)
}
\description{
Synchronise a remote object
}
\examples{
\dontrun{
kcs20=read.neuronlistfh('http://flybrain.mrc-lmb.cam.ac.uk/si/nblast/flycircuit/kcs20.rds')
# update object from the web
kcs20=remotesync(kcs20)
# download all neurons with significant innervation of the vertical lobe
mbvl_neurons=subset(kcs20, (MB_VL_R+MB_VL_L)>200, rval='names')
kcs20=remotesync(kcs20, indices=mbvl_neurons, download.missing=TRUE)
}
}
\seealso{
Other neuronlistfh: \code{\link{[.neuronlistfh}},
  \code{\link{neuronlistfh}},
  \code{\link{read.neuronlistfh}},
  \code{\link{write.neuronlistfh}}
}
\concept{neuronlistfh}
