% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xform.R
\name{xform}
\alias{xform}
\alias{xform.default}
\alias{xform.character}
\alias{xform.list}
\alias{xform.shape3d}
\alias{xform.neuron}
\alias{xform.data.frame}
\alias{xform.dotprops}
\alias{xform.neuronlist}
\title{Transform the 3D location of objects such as neurons}
\usage{
xform(x, reg, ...)

\method{xform}{default}(x, reg, na.action = c("warn", "none", "drop",
  "error"), ...)

\method{xform}{character}(x, reg, ...)

\method{xform}{list}(x, reg, FallBackToAffine = TRUE,
  na.action = "error", ...)

\method{xform}{shape3d}(x, reg, FallBackToAffine = TRUE,
  na.action = "error", ...)

\method{xform}{neuron}(x, reg, FallBackToAffine = TRUE,
  na.action = "error", ...)

\method{xform}{data.frame}(x, reg, subset = NULL, ...)

\method{xform}{dotprops}(x, reg, FallBackToAffine = TRUE, ...)

\method{xform}{neuronlist}(x, reg, subset = NULL, ...,
  OmitFailures = NA, VectoriseRegistrations = FALSE,
  TransformDFCoords = TRUE)
}
\arguments{
\item{x}{an object to transform}

\item{reg}{A registration defined by a matrix, a function, a \code{cmtkreg} 
object, or a character vector specifying a path to one or more 
registrations on disk (see Registrations section).}

\item{...}{additional arguments passed to methods and eventually to 
\code{\link{xformpoints}}}

\item{na.action}{How to handle NAs. NB drop may not work for some classes.}

\item{FallBackToAffine}{Whether to use an affine transform when a cmtk
warping transformation fails.}

\item{subset}{For \code{xform.neuronlist} indices (character/logical/integer)
that specify a subset of the members of \code{x} to be transformed.}

\item{OmitFailures}{Whether to omit neurons for which \code{FUN} gives an 
error. The default value (\code{NA}) will result in nlapply stopping with 
an error message the moment there is an eror. For other values, see 
details.}

\item{VectoriseRegistrations}{When \code{FALSE}, the default, each element of
\code{reg} will be applied sequentially to each element of \code{x}. When 
\code{TRUE}, it is assumed that there is one element of \code{reg} for each
element of \code{x}.}

\item{TransformDFCoords}{If the metadata \code{data.frame} attached to 
\code{x} includes columns that look like x,y,z coordinates, transform those
as well.}
}
\description{
\code{xform} is designed to operate on a variety of data types, especially 
objects encapsulating neurons. \code{xform} depends on two specialised 
downstream functions \code{\link{xformpoints}} and \code{\link{xformimage}}. 
These are user visible any contain some useful documentation, but should only
be required for expert use; in almost all circumstances, you should use only 
\code{xform}.

\code{xform.character} is designed to work with files on disk.
  Presently it is restricted to images, although other datatypes may be
  supported in future.
}
\details{
Methods are provided for some specialised S3 classes. Further 
  methods can of course be constructed for user-defined S3 classes. However 
  this will probably not be necessary if the \code{xyzmatrix} and 
  \code{`xyzmatrix<-`} generics are suitably overloaded \emph{and} the S3 
  object inherits from \code{list}.
  
  Note that given the behaviour of the \code{xyzmatrix} functions, the
  \code{xform.data.frame} method will transform the x,y,z or X,Y,Z columns of
  a data.frame if the data.frame has more than 3 columns, erroring out if no
  such unique columns exist.

TODO get this to work for matrices with more than 3 columns by
  working on xyzmatrix definition.

For the \code{xform.dotprops} method, dotprops tangent vectors will 
  be recalculated from scratch after the points have been transformed (even 
  though the tangent vectors could in theory be transformed more or less 
  correctly). When there are multiple transformations, \code{xform} will take
  care to carry out all transformations before recalculating the vectors.

With \code{xform.neuronlist}, if you want to apply a different 
  registration to each object in the neuronlist \code{x}, then you should use
  \code{VectoriseRegistrations=TRUE}.
  
  When \code{x}'s attached data.frame contains columns called x,y,z or X,Y,Z 
  then these are assumed to be coordinates and also transformed when 
  \code{TransformDFCoords=TRUE} (the default). This provides a mechanism for 
  transforming the soma positions of \code{neuronlist} objects containing 
  \code{dotprops} objects (which do not otherwise store the soma position).
  Note that if transformation fails, a warning will be issued and the points
  will be replaced with \code{NA} values.
}
\section{Registrations}{

  
  When \code{reg} is a character vector, xform's specialised downstream 
  functions will check to see if it defines a path to one (or more) 
  registrations on disk. These can be of two classes
  
  \itemize{
  
  \item CMTK registrations
  
  \item \code{\link{reglist}} objects saved in R's \code{RDS} format (see 
  \code{\link{readRDS}}) which can contain any sequence of registrations 
  supported by nat.
  
  }
  
  If the path does indeed point to a CMTK registration, this method will hand
  off to \code{xformpoints.cmtkreg} or \code{xformimages.cmtkreg}. In this
  case, the character vector may optionally have an attribute, 'swap', a
  logical vector of the same length indicating whether the transformation
  direction should be swapped. At the moment only CMTK registration files are
  supported.
  
  If \code{reg} is a character vector of length >=1 defining a sequence of 
  registration files on disk they should proceed from sample to reference.
  
  Where \code{reg} is a function, it should have a signature like 
  \code{myfun(x,), ...} where the \code{...} \strong{must} be provided in 
  order to swallow any arguments passed from higher level functions that are 
  not relevant to this particular transformation function.
}

\examples{
\dontrun{
kc1=kcs20[[1]]
kc1.default=xform(kc1,function(x,...) x)
stopifnot(isTRUE(all.equal(kc1,kc1.default)))
kc1.5=xform(kc1,function(x,...) x, k=5)
stopifnot(isTRUE(all.equal(kc1.5,kc1.default)))
kc1.20=xform(kc1,function(x,...) x, k=20)
stopifnot(!isTRUE(all.equal(kc1,kc1.20)))

# apply two registrations converting sample->IS2->JFRC2
reg_seq=c("IS2_sample.list", "JFRC2_IS2.list")
xform(kc1, reg_seq)
# apply two registrations, swapping the direction of the second one
# i.e. sample -> IS2 -> FCWB
reg_seq=structure(c("IS2_sample.list", "IS2_FCWB.list"), swap=c(FALSE, TRUE))
xform(kc1, reg_seq)
}
\dontrun{
# apply reg1 to Cell07PNs[[1]], reg2 to Cell07PNs[[2]] etc
regs=c(reg1, reg2, reg3)
nx=xform(Cell07PNs[1:3], reg=regs, VectoriseRegistrations=TRUE)
}
}
\seealso{
\code{\link{xformpoints}}
}
