% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphashape3d.R, R/hxsurf.R
\name{as.mesh3d.ashape3d}
\alias{as.mesh3d.ashape3d}
\alias{as.mesh3d.hxsurf}
\title{Convert an object to an rgl mesh3d}
\usage{
\method{as.mesh3d}{ashape3d}(x, ...)

\method{as.mesh3d}{hxsurf}(x, Regions = NULL, material = NULL,
  drop = TRUE, ...)
}
\arguments{
\item{x}{Object to convert to mesh3d}

\item{...}{Additional arguments for methods}

\item{Regions}{Character vector or regions to select from \code{hxsurf}
object}

\item{material}{rgl materials such as \code{color}}

\item{drop}{Whether to drop unused vertices (default TRUE)}
}
\value{
a \code{\link[rgl]{mesh3d}} object which can be plotted and 
  manipulated using \code{\link{rgl}} and \code{nat} packages.
}
\description{
\code{as.mesh3d.ashape3d} converts an 
  \code{alphashape3d::ashape3d} object into a nat/rgl compatible
  \code{mesh3d} surface

Note that this provides a link to the Rvcg package
}
\details{
An \href{https://en.wikipedia.org/wiki/Alpha_shape}{alpha shape} is 
  a generalisation of a convex hull enclosing a set of points. Unlike a 
  convex hull, the resultant surface can be partly concave allowing the 
  surface to more closely follow the set of points. The parameter alpha
}
\examples{
\donttest{
library(alphashape3d)
kcs20.a=ashape3d(xyzmatrix(kcs20), alpha = 10)
plot(kcs20.a)

# convert to mesh3d
kcs20.mesh=as.mesh3d(kcs20.a)
clear3d()
wire3d(kcs20.mesh)
plot3d(kcs20, col=type, lwd=2)
}
}
\seealso{
\code{\link[alphashape3d]{ashape3d}}, \code{\link[rgl]{mesh3d}}

\code{\link[rgl]{as.mesh3d}}, \code{\link[rgl]{tmesh3d}},
  \code{\link{as.hxsurf}}, \code{\link{read.hxsurf}}

Other hxsurf: \code{\link{as.hxsurf}},
  \code{\link{materials}}, \code{\link{plot3d.hxsurf}},
  \code{\link{read.hxsurf}}, \code{\link{subset.hxsurf}},
  \code{\link{write.hxsurf}}
}
