% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nauf_stan_regs.R
\name{nauf_stan_glm}
\alias{nauf_stan_glm}
\alias{nauf_stan_glm.nb}
\alias{nauf_stan_lm}
\title{Fit a Bayesian fixed effects regression with \code{nauf} contrasts.}
\usage{
nauf_stan_glm(formula, family = gaussian(), data = NULL, weights, subset,
  na.action = na.pass, offset = NULL, model = TRUE, x = TRUE,
  y = TRUE, contrasts = NULL, ncs_scale = attr(formula,
  "standardized.scale"), ..., prior = rstanarm::normal(),
  prior_intercept = rstanarm::normal(), prior_aux = rstanarm::cauchy(0, 5),
  prior_PD = FALSE, algorithm = "sampling", adapt_delta = NULL,
  QR = FALSE, sparse = FALSE)

nauf_stan_lm(formula, data = NULL, subset, weights, na.action = na.pass,
  model = TRUE, x = TRUE, y = TRUE, singular.ok = TRUE,
  contrasts = NULL, offset, ncs_scale = attr(formula, "standardized.scale"),
  ..., prior = rstanarm::R2(stop("'location' must be specified")),
  prior_intercept = NULL, prior_PD = FALSE, algorithm = "sampling",
  adapt_delta = NULL)

nauf_stan_glm.nb(formula, data = NULL, weights, subset, na.action = na.pass,
  offset = NULL, model = TRUE, x = TRUE, y = TRUE, contrasts = NULL,
  link = "log", ncs_scale = attr(formula, "standardized.scale"), ...,
  prior = rstanarm::normal(), prior_intercept = rstanarm::normal(),
  prior_aux = rstanarm::cauchy(0, 5), prior_PD = FALSE,
  algorithm = "sampling", adapt_delta = NULL, QR = FALSE)
}
\arguments{
\item{formula, data, family, subset, weights, na.action, offset, contrasts, model, x, y, ncs_scale}{See
\code{\link{nauf_model.frame}}.}

\item{...}{Further arguments to be passed to \code{\link[rstan]{sampling}}.
See \code{\link[rstanarm]{stan_glmer}} for details.}

\item{algorithm}{Changes from the default \code{"sampling"} result in an
error.  Only MCMC is currently supported.}

\item{singular.ok}{See \code{\link[rstanarm]{stan_lm}}.}

\item{link, prior, prior_intercept, prior_aux, prior_PD, adapt_delta, QR, sparse}{See
\code{\link[rstanarm]{stan_glm}} and \code{\link[rstanarm]{stan_lm}}.}
}
\value{
A \code{\link{nauf.stanreg}} object.
}
\description{
The Bayesian fixed effects regression functions \code{nauf_stan_lm}, \code{nauf_stan_glm.nb},
and \code{nauf_stan_glm} fit linear, negative binomial, and other generalized
linear models, respectively, impelementing \code{\link{nauf_contrasts}}.
}
\details{
\code{nauf_stan_lm}, \code{nauf_stan_glm}, and \code{nauf_stan_glm.nb} are based on
the \code{rstanarm} functions \code{\link[rstanarm]{stan_lm}}, \code{\link[rstanarm]{stan_glm}},
and \code{\link[rstanarm]{stan_glm.nb}}, respectively, but implement
\code{\link{nauf_contrasts}}.  The \code{nauf} functions have all the same
arguments as the functions they are based on, but additionally
\code{ncs_scale}, which is passed to \code{\link{nauf_model.frame}}.  Other
than \code{ncs_scale}, the arguments have the same functions as they do in
the functions they are based on.  The
default values for \code{na.action}, \code{contrasts}, \code{model},
\code{x}, and \code{y} cannot be changed.  For \code{na.action} and
\code{contrasts}, see \code{\link{nauf_model.frame}}.  Forcing \code{model},
\code{x}, and \code{y} to be \code{TRUE} ensures that the fitted model
retains the model frame, model matrix, and response, respectively.  This is
necessary for some generic functions applied to the fitted model to work
properly.
The default priors for the \code{nauf} Bayesian fixed effects regression
functions are the defaults from \code{rstanarm} version 2.15.3; if you have
a later version of the \code{rstanarm} package, then the default priors for
the \code{nauf} regression fitting functions may be different from the
\code{rstanarm} defaults.
}
\examples{
\dontrun{
dat <- fricatives
dat$uvoi[!(dat$lang == "Catalan" & dat$wordpos == "Medial")] <- NA
sobj <- standardize(dur ~ lang * wordpos + uvoi, dat)
mod <- nauf_stan_lm(sobj$formula, sobj$data, prior = R2(location = 0.5))
}

}
\seealso{
\code{\link{nauf_contrasts}} for a description of the treatment of 
  \code{NA} values, \code{\link[rstanarm]{stan_glm}} for a description of 
  the priors, and the documentation for \code{Stan} and the \code{rstan} and 
  \code{rstanarm} packages for algorithmic details.
}

