% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.phantoms.R
\name{make.phantoms}
\alias{make.phantoms}
\alias{make.phantoms,ANY,missing-method}
\alias{make.phantoms,data.frame,numeric-method}
\alias{make.phantoms,matrix,numeric-method}
\title{Add Phantom Rows and Columns}
\usage{
make.phantoms(x, nphantoms, name = "phantom", maxval = Inf, ...)
}
\arguments{
\item{x}{A matrix or data.frame object, with \eqn{N}x\eqn{N} dimensions.}

\item{nphantoms}{An integer, providing the number of phantom elements to add.}

\item{name}{A character string, indicating the name attribute for new
elements.  Defaults to "phantom".}

\item{maxval}{An integer value, the default value to give the pairs of
phantoms (indeces [N+1:N+NP, N+1:N+NP]), assumed to be a maximum distance.
Defaults to Inf.}

\item{\dots}{Additional arguments, not used at this time.}
}
\value{
a matrix or data.frame object
}
\description{
The make.phantoms function will take an \eqn{N}x\eqn{N} matrix and add
\eqn{NP} phantom elements, thus creating a matrix with \eqn{N+NP}x\eqn{N+NP}
dimensions.
}
\details{
This function is internal to the \code{\link{gendistance}} function, but may be
useful in manufacturing personalized distance matrices.  Phantoms are fake
elements that perfectly match all elements.  They can be used to discard a
certain number of elements.
}
\examples{

# 5x5 distance matrix
dist.mat <- matrix(c(0,5,10,15,20,5,0,15,25,35,10,15,0,25,40,15,25,25,0,15,20,35,40,15,0), nrow=5)
# add one phantom element
dm.ph <- make.phantoms(dist.mat, 1)
# create distancematrix object
distancematrix(dm.ph)
# add three phantoms
make.phantoms(dist.mat, 3)

}
\author{
Cole Beck
}
\seealso{
\code{\link{gendistance}} \code{\link{distancematrix}}
}

