% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{nc.is.regular.dimension}
\alias{nc.is.regular.dimension}
\title{Determine if a dimension is regular}
\usage{
nc.is.regular.dimension(d, tolerance = 1e-06)
}
\arguments{
\item{d}{The data to be tested}

\item{tolerance}{The tolerance for variation in step size, as a fraction of the step size.}
}
\value{
TRUE if the data is regular; FALSE if not.
}
\description{
Determine if a dimension is regular (evenly spaced).
}
\details{
Not all dimensions or data are regular (evenly spaced). This function will, given data and optionally a tolerance level, determine if the dimension is regular or not.
}
\examples{
dat <- c(1, 2, 3, 4, 5, 6, 7)
## TRUE
nc.is.regular.dimension(dat)

dat[7] <- 7.001
## FALSE
nc.is.regular.dimension(dat)

}
