% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCFObjects.R
\name{as_CF}
\alias{as_CF}
\title{Create a \code{CFVariable} instance from an R object}
\usage{
as_CF(name, values)
}
\arguments{
\item{name}{The name of the \code{CFVariable} to create.}

\item{values}{The data of this object. This can be an array, matrix or vector
of type \code{logical}, \code{integer}, \code{numeric} or \code{character.}}
}
\value{
An instance of class \link{CFVariable}.
}
\description{
With this function you can convert an R object into a \link{CFVariable}. This can
be an array, matrix or vector of type \code{logical}, \code{integer}, \code{numeric} or
\code{character.}
}
\details{
Dimnames on the R object will be converted to instances of a \link{CFAxis}
descendant class, depending on their values. If the dimnames along a
dimension of the R object can be converted to \code{numeric}, then it will be an
instance of \link{CFAxisNumeric}. If the dimnames are \code{character}, a first attempt
is made to create a \link{CFAxisTime} (i.e. the dimnames have to represent
timestamps), failing that a \link{CFAxisCharacter} will be created. If no dimnames
are set, an instance of \link{CFAxisDiscrete} is generated.

The axes of the \code{CFVariable} are oriented as in the R object. Note that this
is different from standard practice in the netCDF community and the
portability of saved datasets is thus limited. You can improve this situation
by setting the orientation of the axes and by adding attributes.

After creation of the \code{CFVariable}, it is recommended to set other
properties, such as attributes or a coordinate reference system.
}
